/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gametechbcsspellbooks.effects;

import com.gametechbc.gametechbcsspellbooks.init.GSEffects;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class PsychicControlEffect
extends MobEffect {
    private static final Random RANDOM = new Random();

    public PsychicControlEffect() {
        super(MobEffectCategory.HARMFUL, 2744299);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (!entity.level().isClientSide && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            Entity caster = this.getEffectSource(entity);
            if (caster instanceof LivingEntity) {
                LivingEntity newTarget;
                LivingEntity livingCaster = (LivingEntity)caster;
                if (mob.getTarget() == livingCaster) {
                    mob.setTarget(null);
                }
                if ((newTarget = this.findNewTarget(entity, livingCaster)) != null) {
                    mob.setTarget(newTarget);
                }
            }
            for (int i = 0; i < 5; ++i) {
                double offsetX = (entity.getRandom().nextDouble() - 0.5) * (double)entity.getBbWidth();
                double offsetY = entity.getRandom().nextDouble() * (double)entity.getBbHeight();
                double offsetZ = (entity.getRandom().nextDouble() - 0.5) * (double)entity.getBbWidth();
                MagicManager.spawnParticles((Level)entity.level(), (ParticleOptions)ParticleTypes.SCULK_SOUL, (double)(entity.getX() + offsetX), (double)(entity.getY() + offsetY), (double)(entity.getZ() + offsetZ), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.3, (boolean)false);
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 10 == 0;
    }

    private LivingEntity findNewTarget(LivingEntity affectedEntity, LivingEntity caster) {
        Level level = affectedEntity.level();
        double range = 12.0;
        List possibleTargets = level.getEntitiesOfClass(LivingEntity.class, caster.getBoundingBox().inflate(range), entity -> entity != caster && entity != affectedEntity && entity.isAlive() && !(entity instanceof Player));
        if (!possibleTargets.isEmpty()) {
            return (LivingEntity)possibleTargets.get(RANDOM.nextInt(possibleTargets.size()));
        }
        return null;
    }

    private Entity getEffectSource(LivingEntity entity) {
        return entity.getEffect(GSEffects.PSYCHIC_CONTROL) != null ? entity : null;
    }
}

