/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gametechbcsspellbooks.effects;

import com.gametechbc.gametechbcsspellbooks.init.GSParticles;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class CorrodedEffect
extends MobEffect {
    private static final ResourceLocation ARMOR_DOWN_ID = new ResourceLocation("gametechbcs_spellbooks", "corroded_armor");
    private static final ResourceLocation FIRE_MAGIC_DOWN_ID = new ResourceLocation("gametechbcs_spellbooks", "corroded_fire_magic_resist");

    public CorrodedEffect() {
        super(MobEffectCategory.HARMFUL, 0);
        this.addAttributeModifier((Holder)AttributeRegistry.FIRE_MAGIC_RESIST, FIRE_MAGIC_DOWN_ID, -0.05, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        this.addAttributeModifier(Attributes.ARMOR, ARMOR_DOWN_ID, -0.025, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        Level level;
        if (!entity.level().isClientSide() && (level = entity.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int particleCount = 1;
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = (entity.getRandom().nextDouble() - 0.5) * (double)entity.getBbWidth();
                double offsetY = entity.getRandom().nextDouble() * (double)entity.getBbHeight();
                double offsetZ = (entity.getRandom().nextDouble() - 0.5) * (double)entity.getBbWidth();
                double velocityX = (entity.getRandom().nextDouble() - 0.5) * 0.2;
                double velocityY = (entity.getRandom().nextDouble() - 0.5) * 0.2;
                double velocityZ = (entity.getRandom().nextDouble() - 0.5) * 0.2;
                serverLevel.sendParticles((ParticleOptions)GSParticles.ACID_DROP_PARTICLE.get(), entity.getX() + offsetX, entity.getY() + offsetY, entity.getZ() + offsetZ, 1, velocityX, velocityY, velocityZ, 0.0);
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

