/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.worldgen.features;

import com.cmdpro.datanessence.registry.BlockRegistry;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.phys.Vec3;

public class SanctuaryTreeFeature
extends Feature<NoneFeatureConfiguration> {
    public SanctuaryTreeFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        Vec3i offset = new Vec3i(8 + pContext.random().nextIntBetweenInclusive(-8, 8), 0, 8 + pContext.random().nextIntBetweenInclusive(-8, 8));
        float height = pContext.random().nextIntBetweenInclusive(12, 16);
        BlockPos origin = pContext.level().getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, pContext.origin().offset(offset));
        if (!pContext.level().getBlockState(origin.below()).getFluidState().isEmpty()) {
            return false;
        }
        BlockPos center = origin;
        int yRot = pContext.random().nextIntBetweenInclusive(-180, 180);
        Vec3 change = this.calculateViewVector(pContext.random().nextIntBetweenInclusive(-45, -35), yRot);
        ArrayList<BlockPos> leavesPoints = new ArrayList<BlockPos>();
        int y = 0;
        while ((float)y <= height + 1.0f) {
            float logSize = 1.0f;
            for (int x2 = -2; x2 <= 2; ++x2) {
                for (int y2 = -2; y2 <= 2; ++y2) {
                    for (int z2 = -2; z2 <= 2; ++z2) {
                        Vec3 vec3 = new Vec3((double)x2, (double)y2, (double)z2);
                        Vec3 vec32 = new Vec3(0.0, 0.0, 0.0);
                        if (!(vec3.distanceTo(vec32) <= (double)logSize)) continue;
                        BlockPos pos = center.offset(x2, y2, z2);
                        pos = pos.offset((int)(change.x * (double)y), (int)(change.y * (double)y), (int)(change.z * (double)y));
                        if (!pContext.level().getBlockState(pos).canBeReplaced() && !pContext.level().getBlockState(pos).is(BlockRegistry.CRYSTALLINE_LEAVES.get())) continue;
                        this.setBlock((LevelWriter)pContext.level(), pos, BlockRegistry.CRYSTALLINE_LOG.get().defaultBlockState());
                    }
                }
            }
            ++y;
        }
        leavesPoints.add(center.offset((int)(change.x * (double)height), (int)(change.y * (double)height), (int)(change.z * (double)height)));
        Vec3 newChange = this.calculateViewVector(pContext.random().nextIntBetweenInclusive(-60, -50), 180 - yRot);
        float mult = height / 2.0f;
        for (int i = 0; i < 2; ++i) {
            float newHeight = pContext.random().nextIntBetweenInclusive(8, 12);
            center = origin.offset((int)(change.x * (double)mult), (int)(change.y * (double)mult), (int)(change.z * (double)mult));
            int y2 = 0;
            while ((float)y2 <= newHeight) {
                float logSize = 1.0f;
                for (int x2 = -2; x2 <= 2; ++x2) {
                    for (int y22 = -2; y22 <= 2; ++y22) {
                        for (int z2 = -2; z2 <= 2; ++z2) {
                            Vec3 vec3 = new Vec3((double)x2, (double)y22, (double)z2);
                            Vec3 vec33 = new Vec3(0.0, 0.0, 0.0);
                            if (!(vec3.distanceTo(vec33) <= (double)logSize)) continue;
                            BlockPos pos = center.offset(x2, y22, z2);
                            pos = pos.offset((int)(newChange.x * (double)y2), (int)(newChange.y * (double)y2), (int)(newChange.z * (double)y2));
                            if (!pContext.level().getBlockState(pos).canBeReplaced() && !pContext.level().getBlockState(pos).is(BlockRegistry.CRYSTALLINE_LEAVES.get())) continue;
                            this.setBlock((LevelWriter)pContext.level(), pos, BlockRegistry.CRYSTALLINE_LOG.get().defaultBlockState());
                        }
                    }
                }
                ++y2;
            }
            leavesPoints.add(center.offset((int)(newChange.x * (double)newHeight), (int)(newChange.y * (double)newHeight), (int)(newChange.z * (double)newHeight)));
            mult += height / 2.0f;
        }
        BlockPos highestPos = null;
        BlockPos lowestPos = null;
        int minX = center.getX();
        int minZ = center.getZ();
        int maxX = center.getX();
        int maxZ = center.getZ();
        for (BlockPos i : leavesPoints) {
            if (highestPos == null || highestPos.getY() < i.getY()) {
                highestPos = i;
            }
            if (lowestPos == null || lowestPos.getY() > i.getY()) {
                lowestPos = i;
            }
            if (i.getX() < minX) {
                minX = i.getX();
            }
            if (i.getZ() < minZ) {
                minZ = i.getZ();
            }
            if (i.getX() > maxX) {
                maxX = i.getX();
            }
            if (i.getZ() <= maxZ) continue;
            maxZ = i.getZ();
        }
        highestPos = highestPos.offset(0, 10, 0);
        BlockPos middlePos = new BlockPos(minX + (maxX - minX) / 2, lowestPos.getY() + (highestPos.getY() - lowestPos.getY()) / 2, minZ + (maxZ - minZ) / 2);
        double largestDistanceFromCenter = 0.0;
        for (BlockPos i : leavesPoints) {
            if (!(i.getCenter().multiply(1.0, 0.0, 1.0).distanceTo(middlePos.getCenter().multiply(1.0, 0.0, 1.0)) > largestDistanceFromCenter)) continue;
            largestDistanceFromCenter = i.getCenter().multiply(1.0, 0.0, 1.0).distanceTo(middlePos.getCenter().multiply(1.0, 0.0, 1.0));
        }
        largestDistanceFromCenter += 4.0;
        float curveHeight = highestPos.getY() - lowestPos.getY();
        return true;
    }

    public final Vec3 calculateViewVector(float pXRot, float pYRot) {
        float f = pXRot * ((float)Math.PI / 180);
        float f1 = -pYRot * ((float)Math.PI / 180);
        float f2 = Mth.cos((float)f1);
        float f3 = Mth.sin((float)f1);
        float f4 = Mth.cos((float)f);
        float f5 = Mth.sin((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }
}

