/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.worldgen.features;

import com.cmdpro.datanessence.block.world.EssenceCrystal;
import com.cmdpro.datanessence.registry.BlockRegistry;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class EssenceCrystalFeature
extends Feature<NoneFeatureConfiguration> {
    public EssenceCrystalFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        boolean reachedBottomOrTop = false;
        int yChange = -1;
        if (pContext.random().nextBoolean()) {
            yChange = 1;
        }
        BlockPos pos = pContext.origin();
        if (!pContext.level().isEmptyBlock(pos)) {
            return false;
        }
        for (int i = 0; i < 64; ++i) {
            if (!pContext.level().getBlockState(pContext.origin().offset(0, i * yChange, 0)).isSolid()) continue;
            reachedBottomOrTop = true;
            pos = pContext.origin().offset(0, i + -yChange, 0);
            break;
        }
        if (!reachedBottomOrTop) {
            return false;
        }
        int amount = pContext.random().nextInt(2, 4);
        for (int i = 0; i < amount; ++i) {
            int xOffset = 0;
            int yOffset = 0;
            int zOffset = 0;
            Direction dir = Direction.DOWN;
            boolean foundValid = false;
            for (int o = 0; o <= 10; ++o) {
                Direction[] directions;
                xOffset = pContext.random().nextIntBetweenInclusive(-2, 2);
                yOffset = pContext.random().nextIntBetweenInclusive(-2, 2);
                zOffset = pContext.random().nextIntBetweenInclusive(-2, 2);
                BlockPos offset = pos.offset(xOffset, yOffset, zOffset);
                BlockState state = pContext.level().getBlockState(offset);
                if (!state.isAir()) continue;
                for (Direction p : directions = Direction.allShuffled((RandomSource)pContext.random()).toArray(new Direction[0])) {
                    if (!pContext.level().getBlockState(offset.relative(p)).isCollisionShapeFullBlock((BlockGetter)pContext.level(), offset.relative(p)) || !pContext.level().getBlockState(offset.relative(p)).is(BlockTags.BASE_STONE_OVERWORLD)) continue;
                    dir = p.getOpposite();
                    foundValid = true;
                    break;
                }
                if (foundValid) break;
            }
            if (!foundValid) continue;
            this.setBlock((LevelWriter)pContext.level(), pos.offset(xOffset, yOffset, zOffset), (BlockState)BlockRegistry.ESSENCE_CRYSTAL.get().defaultBlockState().setValue((Property)EssenceCrystal.FACING, (Comparable)dir));
        }
        return true;
    }
}

