/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.worldgen.features;

import com.cmdpro.datanessence.registry.BlockRegistry;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class CalciteSpireFeature
extends Feature<NoneFeatureConfiguration> {
    public CalciteSpireFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        Vec3i offset = new Vec3i(8 + pContext.random().nextIntBetweenInclusive(-4, 4), 0, 8 + pContext.random().nextIntBetweenInclusive(-4, 4));
        float height = 50.0f * Mth.nextFloat((RandomSource)pContext.random(), (float)0.5f, (float)1.5f);
        float spiralSize = Mth.nextFloat((RandomSource)pContext.random(), (float)0.75f, (float)1.0f);
        float dirChange = pContext.random().nextBoolean() ? Mth.nextFloat((RandomSource)pContext.random(), (float)-15.0f, (float)-5.0f) : Mth.nextFloat((RandomSource)pContext.random(), (float)5.0f, (float)10.0f);
        BlockPos origin = pContext.level().getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, pContext.origin().offset(offset));
        if (!pContext.level().getBlockState(origin.below()).getFluidState().isEmpty()) {
            return false;
        }
        float dir = Mth.nextFloat((RandomSource)pContext.random(), (float)0.0f, (float)360.0f);
        int y = -5;
        while ((float)y <= height) {
            float range = (height - (float)y) / 10.0f;
            if (y < 0) {
                range = 5 - y * -1;
            }
            float size = (height - (float)y) / 15.0f;
            if (y < 0) {
                size *= 1.0f - (float)y * -1.0f / 5.0f;
            }
            size *= spiralSize;
            float yDivideForSpeed = 20.0f;
            int splits = (int)(3.0f * Math.clamp((float)y / yDivideForSpeed, 1.0f, Float.MAX_VALUE));
            for (int s = 0; s < splits; ++s) {
                for (int i = 0; i < 2; ++i) {
                    float dirOffset = i * 180;
                    BlockPos posCenter = origin.offset(new Vec3i((int)(Math.cos(Math.toRadians(dir + dirOffset)) * (double)(range * 2.0f + 4.0f)), y, (int)(Math.sin(Math.toRadians(dir + dirOffset)) * (double)(range * 2.0f + 4.0f))));
                    int x = (int)(-Math.floor(size));
                    while ((double)x <= Math.ceil(size)) {
                        int z = (int)(-Math.floor(size));
                        while ((double)z <= Math.ceil(size)) {
                            int y2 = (int)(-Math.floor(size));
                            while ((double)y2 <= Math.ceil(size)) {
                                BlockPos pos = posCenter.offset(new Vec3i(x, y2, z));
                                if (posCenter.getCenter().distanceTo(pos.getCenter()) <= (double)size && pContext.level().getBlockState(pos).canBeReplaced()) {
                                    this.setBlock((LevelWriter)pContext.level(), pos, BlockRegistry.SPIRE_GLASS.get().defaultBlockState());
                                }
                                ++y2;
                            }
                            ++z;
                        }
                        ++x;
                    }
                }
                dir += dirChange * Math.clamp((float)y / yDivideForSpeed, 1.0f, Float.MAX_VALUE) / (float)splits;
            }
            for (int x = -10; x <= 10; ++x) {
                for (int z = -10; z <= 10; ++z) {
                    BlockPos pos = origin.offset(new Vec3i(x, y, z));
                    double dist = origin.offset(0, y, 0).getCenter().distanceTo(pos.getCenter());
                    if (!(dist <= (double)range) || !(dist <= 1.0) && !(dist + 1.0 <= (double)range) && pContext.random().nextIntBetweenInclusive(0, 4) == 0) continue;
                    this.setBlock((LevelWriter)pContext.level(), pos, Blocks.CALCITE.defaultBlockState());
                }
            }
            ++y;
        }
        return true;
    }
}

