/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.screen.widget;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidWidget
extends AbstractWidget {
    public IFluidHandler handler;
    public int slot;
    public boolean fillWithAmount;

    public FluidWidget(int pX, int pY, IFluidHandler handler, int slot, boolean fillWithAmount) {
        this(pX, pY, 16, 16, handler, slot, fillWithAmount);
    }

    public FluidWidget(int pX, int pY, int pWidth, int pHeight, IFluidHandler handler, int slot, boolean fillWithAmount) {
        super(pX, pY, pWidth, pHeight, (Component)Component.empty());
        this.handler = handler;
        this.slot = slot;
        this.fillWithAmount = fillWithAmount;
    }

    protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        FluidStack fluid = this.handler.getFluidInTank(this.slot);
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        ResourceLocation stillTexture = fluidTypeExtensions.getStillTexture(fluid);
        if (stillTexture != null) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(stillTexture);
            int tintColor = fluidTypeExtensions.getTintColor(fluid);
            Color tint = new Color(tintColor);
            int height = this.getHeight();
            if (this.fillWithAmount) {
                height = (int)((float)height * ((float)this.handler.getFluidInTank(this.slot).getAmount() / (float)this.handler.getTankCapacity(this.slot)));
            }
            pGuiGraphics.blit(this.getX(), this.getY() + (this.getHeight() - height), 0, this.getWidth(), height, sprite, (float)tint.getRed() / 255.0f, (float)tint.getGreen() / 255.0f, (float)tint.getBlue() / 255.0f, (float)tint.getAlpha() / 255.0f);
        }
        if (!fluid.isEmpty()) {
            this.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.widget.fluid", (Object[])new Object[]{fluid.getAmount(), this.handler.getTankCapacity(0), fluid.getHoverName()})));
        } else {
            this.setTooltip(Tooltip.create((Component)Component.empty()));
        }
        if (this.isHovered) {
            pGuiGraphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), Integer.MAX_VALUE);
        }
    }

    protected boolean clicked(double pMouseX, double pMouseY) {
        return false;
    }

    protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
    }
}

