/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.screen;

import com.cmdpro.datanessence.registry.DataComponentRegistry;
import com.cmdpro.datanessence.registry.MenuRegistry;
import com.cmdpro.datanessence.screen.slot.UnclickableInventorySlot;
import com.cmdpro.datanessence.screen.slot.UnuseableSlot;
import com.cmdpro.datanessence.util.IDataNEssenceMenuHelper;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;

public class FilterNodeUpgradeMenu
extends AbstractContainerMenu
implements IDataNEssenceMenuHelper {
    public final ItemStack stack;
    private final Level level;
    Slot slot;

    public ItemStack quickMoveStack(Player player, int index) {
        return this.guiHelperQuickMoveStack(player, index, 1, this);
    }

    @Override
    public boolean guiHelperMoveItemStackTo(ItemStack pStack, int pStartIndex, int pEndIndex, boolean pReverseDirection) {
        return this.moveItemStackTo(pStack, pStartIndex, pEndIndex, pReverseDirection);
    }

    public FilterNodeUpgradeMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, inv.player.getSlot(extraData.readInt()).get());
    }

    public FilterNodeUpgradeMenu(int pContainerId, Inventory inv, ItemStack stack) {
        super(MenuRegistry.FILTER_NODE_UPGRADE_MENU.get(), pContainerId);
        this.stack = stack;
        this.level = inv.player.level();
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.slot = this.addSlot(new UnuseableSlot(80, 34));
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        super.clicked(slotId, button, clickType, player);
        if (slotId == this.slots.indexOf((Object)this.slot) && (clickType.equals((Object)ClickType.PICKUP) || clickType.equals((Object)ClickType.SWAP))) {
            ItemStack carried = this.getCarried();
            this.stack.set((DataComponentType)DataComponentRegistry.FILTER_STACK.get(), (Object)ItemContainerContents.fromItems(List.of(carried)));
        }
    }

    public boolean stillValid(Player pPlayer) {
        return true;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                int slot = l + i * 9 + 9;
                if (playerInventory.getItem(slot) == this.stack) {
                    this.addSlot(new UnclickableInventorySlot(playerInventory, slot, 8 + l * 18, 84 + i * 18));
                    continue;
                }
                this.addSlot(new Slot((Container)playerInventory, slot, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            if (playerInventory.getItem(i) == this.stack) {
                this.addSlot(new UnclickableInventorySlot(playerInventory, i, 8 + i * 18, 142));
                continue;
            }
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

