/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.screen;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.DataNEssenceRegistries;
import com.cmdpro.datanessence.api.essence.EssenceBarBackgroundTypes;
import com.cmdpro.datanessence.api.util.client.ClientEssenceBarUtil;
import com.cmdpro.datanessence.moddata.ClientPlayerData;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.screen.DryingTableMenu;
import com.cmdpro.datanessence.screen.widget.FluidWidget;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class DryingTableScreen
extends AbstractContainerScreen<DryingTableMenu> {
    public static final ResourceLocation TEXTURE = DataNEssence.locate("textures/gui/drying_table.png");

    public DryingTableScreen(DryingTableMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void init() {
        super.init();
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.addRenderableWidget((GuiEventListener)new FluidWidget(x + 66, y + 7, 16, 16, ((DryingTableMenu)this.menu).blockEntity.getFluidHandler(), 0, true));
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        if (((DryingTableMenu)this.menu).blockEntity.workTime >= 0 && ((DryingTableMenu)this.menu).blockEntity.maxWorkTime != -1) {
            guiGraphics.blit(TEXTURE, x + 81, y + 28, 177, 0, 14, (int)Math.ceil(14.0f * ((float)((DryingTableMenu)this.menu).blockEntity.workTime / (float)((DryingTableMenu)this.menu).blockEntity.maxWorkTime)));
        }
        ClientEssenceBarUtil.drawEssenceBar(guiGraphics, x + 8, y + 17, EssenceTypeRegistry.ESSENCE.get(), ((DryingTableMenu)this.menu).blockEntity.getStorage().getEssence(EssenceTypeRegistry.ESSENCE.get()), ((DryingTableMenu)this.menu).blockEntity.getStorage().getMaxEssence(), EssenceBarBackgroundTypes.INDUSTRIAL);
        ClientEssenceBarUtil.drawEssenceIcon(guiGraphics, x + 7, y + 6, EssenceTypeRegistry.ESSENCE.get(), EssenceBarBackgroundTypes.INDUSTRIAL, ClientPlayerData.getUnlockedEssences().getOrDefault(DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.getKey((Object)EssenceTypeRegistry.ESSENCE.get()), false));
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        ArrayList<FormattedCharSequence> component = new ArrayList<FormattedCharSequence>();
        Component essence = ClientEssenceBarUtil.getEssenceBarTooltip(pMouseX, pMouseY, x + 8, y + 17, EssenceTypeRegistry.ESSENCE.get(), ((DryingTableMenu)this.menu).blockEntity.getStorage().getEssence(EssenceTypeRegistry.ESSENCE.get()));
        if (essence != null) {
            component.clear();
            component.add(essence.getVisualOrderText());
        }
        if (component != null) {
            pGuiGraphics.renderTooltip(this.font, component, pMouseX, pMouseY);
        }
    }
}

