/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.screen;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.databank.Minigame;
import com.cmdpro.datanessence.api.databank.MinigameCreator;
import com.cmdpro.datanessence.data.databank.DataBankEntries;
import com.cmdpro.datanessence.data.databank.DataBankEntry;
import com.cmdpro.datanessence.data.datatablet.Entries;
import com.cmdpro.datanessence.data.datatablet.Entry;
import com.cmdpro.datanessence.moddata.ClientPlayerData;
import com.cmdpro.datanessence.moddata.ClientPlayerUnlockedEntries;
import com.cmdpro.datanessence.networking.ModMessages;
import com.cmdpro.datanessence.networking.packet.c2s.PlayerFinishDataBankMinigame;
import com.cmdpro.datanessence.registry.SoundRegistry;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;

public class DataBankScreen
extends Screen {
    public static final ResourceLocation TEXTURE = DataNEssence.locate("textures/gui/data_bank.png");
    public static int imageWidth = 256;
    public static int imageHeight = 166;
    public double offsetX;
    public double offsetY;
    public int screenType;
    public DataBankEntry clickedEntry;
    public Minigame[] minigames;
    public int minigameProgress;
    public int minigameCompletionWait = -1;
    public HashMap<ResourceLocation, Integer> downloading = new HashMap();
    public static final int downloadTime = 20;

    public DataBankScreen(Component pTitle) {
        super(pTitle);
    }

    public boolean isUnlocked(Entry entry) {
        return this.downloading.containsKey(entry.id) || entry.isUnlockedClient();
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        int x = (this.width - imageWidth) / 2;
        int y = (this.height - imageHeight) / 2;
        if (pButton == 0 && this.screenType == 0) {
            int currentTier = -1;
            int y2 = 0;
            int x2 = 4;
            ArrayList<DataBankEntry> entries = new ArrayList<DataBankEntry>(DataBankEntries.clientEntries.values().stream().toList());
            entries.sort(Comparator.comparingInt(a -> a.tier));
            for (DataBankEntry i : entries) {
                Entry entry;
                boolean isDownloading = this.downloading.containsKey(i.id);
                if (!isDownloading && (i.tier > ClientPlayerData.getTier() || ClientPlayerUnlockedEntries.getUnlocked().contains(i.entry) || ClientPlayerUnlockedEntries.getIncomplete().containsKey(i.entry)) || (entry = Entries.entries.get(i.entry)) == null || !this.isUnlocked(entry) && !isDownloading) continue;
                if (i.tier != currentTier) {
                    currentTier = i.tier;
                    y2 += 32;
                    x2 = 4;
                }
                x2 += 30;
                if (isDownloading || !(pMouseX >= (double)(x2 - 10) + this.offsetX + (double)x) || !(pMouseX <= (double)(x2 + 10) + this.offsetX + (double)x) || !(pMouseY >= (double)(y2 - 10) + this.offsetY + (double)y) || !(pMouseY <= (double)(y2 + 10) + this.offsetY + (double)y)) continue;
                this.screenType = 1;
                this.clickedEntry = i;
                this.minigameProgress = 0;
                ArrayList<Minigame> minigames2 = new ArrayList<Minigame>();
                for (MinigameCreator o : i.minigames) {
                    minigames2.add(o.createMinigame());
                }
                this.minigames = minigames2.toArray(new Minigame[0]);
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundRegistry.UI_CLICK.value()), (float)1.0f));
                return true;
            }
        }
        if (this.screenType == 1 && this.minigameCompletionWait == -1 && this.isMouseInsideMinigame(pMouseX, pMouseY) && this.minigameProgress < this.minigames.length) {
            double mouseX = pMouseX - (double)(x + imageWidth / 2 - 75);
            double mouseY = pMouseY - (double)(y + imageHeight / 2 - 75);
            this.minigames[this.minigameProgress].mouseClicked(mouseX, mouseY, pButton);
            return true;
        }
        if (pButton == 1 && this.screenType == 1 && this.minigameCompletionWait == -1) {
            this.screenType = 0;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        int x = (this.width - imageWidth) / 2;
        int y = (this.height - imageHeight) / 2;
        if (this.screenType == 0) {
            if (pButton == 0) {
                this.offsetX += pDragX;
                this.offsetY += pDragY;
                if (this.offsetX > 0.0) {
                    this.offsetX = 0.0;
                }
                if (this.offsetY > 0.0) {
                    this.offsetY = 0.0;
                }
                return true;
            }
            return false;
        }
        if (this.screenType == 1 && this.minigameCompletionWait == -1 && this.isMouseInsideMinigame(pMouseX, pMouseY) && this.isMouseInsideMinigame(pMouseX + pDragX, pMouseY + pDragY) && this.minigameProgress < this.minigames.length) {
            double mouseX = pMouseX - (double)(x + imageWidth / 2 - 75);
            double mouseY = pMouseY - (double)(y + imageHeight / 2 - 75);
            this.minigames[this.minigameProgress].mouseDragged(mouseX, mouseY, pButton, pDragX, pDragY);
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        int x = (this.width - imageWidth) / 2;
        int y = (this.height - imageHeight) / 2;
        if (this.screenType == 1 && this.minigameCompletionWait == -1 && this.isMouseInsideMinigame(pMouseX, pMouseY) && this.minigameProgress < this.minigames.length) {
            double mouseX = pMouseX - (double)(x + imageWidth / 2 - 75);
            double mouseY = pMouseY - (double)(y + imageHeight / 2 - 75);
            this.minigames[this.minigameProgress].mouseReleased(mouseX, mouseY, pButton);
            return true;
        }
        return false;
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.screenType == 1 && this.minigameCompletionWait == -1 && this.minigameProgress < this.minigames.length) {
            this.minigames[this.minigameProgress].keyPressed(pKeyCode, pScanCode, pModifiers);
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public boolean keyReleased(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.screenType == 1 && this.minigameCompletionWait == -1 && this.minigameProgress < this.minigames.length) {
            this.minigames[this.minigameProgress].keyReleased(pKeyCode, pScanCode, pModifiers);
        }
        return super.keyReleased(pKeyCode, pScanCode, pModifiers);
    }

    public void tick() {
        super.tick();
        if (this.screenType == 1) {
            if (this.minigameProgress >= this.minigames.length) {
                Entry entry = Entries.entries.get(this.clickedEntry.entry);
                if (!entry.completionStages.isEmpty()) {
                    if (!ClientPlayerUnlockedEntries.getIncomplete().containsKey(this.clickedEntry.entry)) {
                        ClientPlayerUnlockedEntries.getIncomplete().put(this.clickedEntry.entry, 0);
                    }
                } else if (!ClientPlayerUnlockedEntries.getUnlocked().contains(this.clickedEntry.entry)) {
                    ClientPlayerUnlockedEntries.getUnlocked().add(this.clickedEntry.entry);
                }
                this.downloading.put(this.clickedEntry.id, 20);
                ModMessages.sendToServer(new PlayerFinishDataBankMinigame(this.clickedEntry.id));
                this.screenType = 0;
            } else {
                this.minigames[this.minigameProgress].tick();
                if (this.minigames[this.minigameProgress].isFinished() && this.minigameCompletionWait == -1) {
                    this.minigameCompletionWait = 40;
                }
                if (this.minigameCompletionWait > 0) {
                    --this.minigameCompletionWait;
                    if (this.minigameCompletionWait <= 0) {
                        this.minigameCompletionWait = -1;
                        ++this.minigameProgress;
                    }
                }
            }
        } else {
            this.minigameCompletionWait = -1;
            this.minigames = null;
        }
        for (Map.Entry i : this.downloading.entrySet().stream().toList()) {
            if ((Integer)i.getValue() - 1 <= 0) {
                this.downloading.remove(i.getKey());
                continue;
            }
            this.downloading.put((ResourceLocation)i.getKey(), (Integer)i.getValue() - 1);
        }
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.width - imageWidth) / 2;
        int y = (this.height - imageHeight) / 2;
        pGuiGraphics.blit(TEXTURE, x, y, 0, 0, imageWidth, imageHeight);
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    public void onClose() {
        if (this.minigameCompletionWait == -1) {
            if (this.screenType == 0) {
                super.onClose();
            } else {
                this.screenType = 0;
            }
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        this.renderBg(graphics, delta, mouseX, mouseY);
        int x = (this.width - imageWidth) / 2;
        int y = (this.height - imageHeight) / 2;
        if (this.screenType == 1 && this.minigameProgress < this.minigames.length) {
            MutableComponent minigameName = Component.translatable((String)this.minigames[this.minigameProgress].getLocalizationKey());
            graphics.drawCenteredString(Minecraft.getInstance().font, (Component)minigameName, x + imageWidth / 2, y - 8, 0xFFFFFF);
        }
        graphics.enableScissor(x + 3, y + 3, x + imageWidth - 3, y + imageHeight - 3);
        if (this.screenType == 0) {
            this.drawEntries(graphics, delta, mouseX, mouseY);
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 399.0f);
            graphics.drawCenteredString(Minecraft.getInstance().font, (Component)Component.translatable((String)"data_tablet.tier", (Object[])new Object[]{ClientPlayerData.getTier()}), x + imageWidth / 2, y + 8, -3601013);
            graphics.blit(TEXTURE, x + 3, y + 3, 20, 166, 4, 4);
            graphics.blit(TEXTURE, x + 3, y + imageHeight - 7, 20, 170, 4, 4);
            graphics.blit(TEXTURE, x + imageWidth - 7, y + 3, 24, 166, 4, 4);
            graphics.blit(TEXTURE, x + imageWidth - 7, y + imageHeight - 7, 24, 170, 4, 4);
            graphics.pose().popPose();
        } else if (this.screenType == 1) {
            if (this.minigameProgress < this.minigames.length) {
                this.drawMinigame(this.minigames[this.minigameProgress], graphics, delta, mouseX, mouseY);
            }
            graphics.blit(TEXTURE, x + 26 - 10, y + 26 - 10, 0, 166, 20, 20);
            graphics.renderItem(this.clickedEntry.icon, x + 26 - 8, y + 26 - 8);
            if (this.minigameCompletionWait > 0) {
                Color fade = new Color(1.0f, 1.0f, 1.0f, 1.0f - (float)this.minigameCompletionWait / 40.0f);
                Color fade2 = new Color(0.0f, 0.0f, 0.0f, 1.0f - (float)this.minigameCompletionWait / 40.0f);
                MutableComponent completed = Component.translatable((String)"data_tablet.databank_minigame_completed");
                int textWidth = Minecraft.getInstance().font.width((FormattedText)completed);
                Objects.requireNonNull(Minecraft.getInstance().font);
                int textHeight = 9;
                graphics.fillGradient(x + imageWidth / 2 - (textWidth + 5), y + imageHeight / 2 - (textHeight + 10), x + imageWidth / 2 + (textWidth + 5), y + imageHeight / 2, 0, fade2.getRGB());
                graphics.fillGradient(x + imageWidth / 2 - (textWidth + 5), y + imageHeight / 2, x + imageWidth / 2 + (textWidth + 5), y + imageHeight / 2 + (textHeight + 10), fade2.getRGB(), 0);
                graphics.drawCenteredString(Minecraft.getInstance().font, (Component)completed, x + imageWidth / 2, y + imageHeight / 2 - textHeight / 2, fade.getRGB());
            }
        }
        graphics.disableScissor();
        if (this.screenType == 0) {
            int currentTier = -1;
            int y2 = 0;
            int x2 = 4;
            ArrayList<DataBankEntry> entries = new ArrayList<DataBankEntry>(DataBankEntries.clientEntries.values().stream().toList());
            entries.sort(Comparator.comparingInt(a -> a.tier));
            for (DataBankEntry i : entries) {
                Entry entry;
                if (!this.downloading.containsKey(i.id) && (i.tier > ClientPlayerData.getTier() || ClientPlayerUnlockedEntries.getUnlocked().contains(i.entry) || ClientPlayerUnlockedEntries.getIncomplete().containsKey(i.entry)) || (entry = Entries.entries.get(i.entry)) == null || !this.isUnlocked(entry) && !this.downloading.containsKey(i.id)) continue;
                if (i.tier != currentTier) {
                    currentTier = i.tier;
                    y2 += 32;
                    x2 = 4;
                }
                if (!((double)mouseX >= (double)((x2 += 30) - 10) + this.offsetX + (double)x) || !((double)mouseX <= (double)(x2 + 10) + this.offsetX + (double)x) || !((double)mouseY >= (double)(y2 - 10) + this.offsetY + (double)y) || !((double)mouseY <= (double)(y2 + 10) + this.offsetY + (double)y)) continue;
                graphics.renderTooltip(Minecraft.getInstance().font, i.name, mouseX, mouseY);
                break;
            }
            boolean anyUnfinished = false;
            for (DataBankEntry i : entries) {
                Entry entry;
                if (!this.downloading.containsKey(i.id) && (i.tier > ClientPlayerData.getTier() || ClientPlayerUnlockedEntries.getUnlocked().contains(i.entry) || ClientPlayerUnlockedEntries.getIncomplete().containsKey(i.entry)) || (entry = Entries.entries.get(i.entry)) != null && !this.isUnlocked(entry)) continue;
                anyUnfinished = true;
            }
            if (!anyUnfinished) {
                graphics.blit(TEXTURE, this.width / 2 - 23, this.height / 2 - 33, 39, 166, 46, 46);
                graphics.drawCenteredString(Minecraft.getInstance().font, (Component)Component.translatable((String)"data_tablet.databank_no_entries_left"), this.width / 2, this.height / 2, new Color(255, 150, 181).getRGB());
            }
        } else if (this.screenType == 1) {
            if (this.isMouseInsideMinigame(mouseX, mouseY)) {
                if (this.minigameProgress < this.minigames.length) {
                    graphics.renderTooltip(Minecraft.getInstance().font, this.minigames[this.minigameProgress].getTooltip(), mouseX, mouseY);
                }
            } else if (mouseX >= x + 26 - 10 && mouseY >= y + 26 - 10 && mouseX <= x + 26 + 10 && mouseY <= y + 26 + 10) {
                graphics.renderTooltip(Minecraft.getInstance().font, this.clickedEntry.name, mouseX, mouseY);
            }
        }
    }

    public boolean isMouseInsideMinigame(double pMouseX, double pMouseY) {
        int x = (this.width - imageWidth) / 2;
        int y = (this.height - imageHeight) / 2;
        return pMouseX >= (double)(x + imageWidth / 2 - 75) && pMouseY >= (double)(y + imageHeight / 2 - 75) && pMouseX <= (double)(x + imageWidth / 2 + 75) && pMouseY <= (double)(y + imageHeight / 2 + 75);
    }

    public void drawMinigame(Minigame minigame, GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int x = (this.width - imageWidth) / 2;
        int y = (this.height - imageHeight) / 2;
        pGuiGraphics.fill(x + imageWidth / 2 - 75, y + imageHeight / 2 - 75, x + imageWidth / 2 + 75, y + imageHeight / 2 + 75, -16777216);
        pGuiGraphics.enableScissor(x + imageWidth / 2 - 75, y + imageHeight / 2 - 75, x + imageWidth / 2 + 75, y + imageHeight / 2 + 75);
        minigame.render(this, pGuiGraphics, pPartialTick, pMouseX, pMouseY, x + imageWidth / 2 - 75, y + imageHeight / 2 - 75);
        pGuiGraphics.disableScissor();
    }

    public void drawEntries(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int x = (this.width - imageWidth) / 2;
        int y = (this.height - imageHeight) / 2;
        int currentTier = -1;
        int y2 = 0;
        int x2 = 4;
        HashMap<Integer, Integer> tiers = new HashMap<Integer, Integer>();
        ArrayList<DataBankEntry> entries = new ArrayList<DataBankEntry>(DataBankEntries.clientEntries.values().stream().toList());
        entries.sort(Comparator.comparingInt(a -> a.tier));
        for (DataBankEntry i : entries) {
            Entry entry;
            if (!this.downloading.containsKey(i.id) && (i.tier > ClientPlayerData.getTier() || ClientPlayerUnlockedEntries.getUnlocked().contains(i.entry) || ClientPlayerUnlockedEntries.getIncomplete().containsKey(i.entry)) || (entry = Entries.entries.get(i.entry)) == null || !this.isUnlocked(entry)) continue;
            if (i.tier != currentTier) {
                currentTier = i.tier;
                y2 += 32;
                x2 = 4;
            }
            pGuiGraphics.blit(TEXTURE, x + ((x2 += 30) - 10) + (int)this.offsetX, y + (y2 - 10) + (int)this.offsetY, 0, 166, 20, 20);
            pGuiGraphics.renderItem(i.icon, x + (x2 - 8) + (int)this.offsetX, y + (y2 - 8) + (int)this.offsetY);
            if (this.downloading.containsKey(i.id)) {
                pGuiGraphics.pose().pushPose();
                pGuiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
                BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
                float radius = 8.0f;
                Vec2 center = new Vec2((float)(x + x2 + (int)this.offsetX), (float)(y + y2 + (int)this.offsetY));
                Color color = new Color(0.75f, 0.0f, 0.75f, 0.5f);
                RenderSystem.enableBlend();
                RenderSystem.setShader(GameRenderer::getPositionColorShader);
                builder.addVertex(pGuiGraphics.pose().last(), center.x, center.y, 0.0f).setColor(color.getRGB());
                for (int deg = (int)(360.0f * (1.0f - Math.clamp(((float)this.downloading.get(i.id).intValue() - pPartialTick) / 20.0f, 0.0f, 1.0f))); deg >= 0; --deg) {
                    float rad = (float)(deg - 90) / 180.0f * (float)Math.PI;
                    builder.addVertex(pGuiGraphics.pose().last(), center.x + Mth.cos((float)rad) * radius, center.y + Mth.sin((float)rad) * radius, 0.0f).setColor(color.getRGB());
                }
                builder.addVertex(pGuiGraphics.pose().last(), center.x, center.y, 0.0f).setColor(color.getRGB());
                BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                pGuiGraphics.blit(TEXTURE, (int)center.x - 8, (int)center.y - 8, 85, 166, 16, 16);
                RenderSystem.disableBlend();
                pGuiGraphics.pose().popPose();
            }
            if (tiers.containsKey(i.tier)) {
                tiers.put(i.tier, (Integer)tiers.get(i.tier) + 1);
                continue;
            }
            tiers.put(i.tier, 0);
        }
        int o = 1;
        for (Map.Entry i : tiers.entrySet()) {
            pGuiGraphics.blit(TEXTURE, x + 4 + (int)this.offsetX, y + (32 * o - 14) + (int)this.offsetY, 28, 166, 3, 28);
            int width = (Integer)i.getValue() * 30 + 30;
            for (int p = 0; p < width + 13; ++p) {
                pGuiGraphics.blit(TEXTURE, x + 7 + p + (int)this.offsetX, y + (32 * o - 14) + (int)this.offsetY, 30, 166, 1, 28);
            }
            pGuiGraphics.blit(TEXTURE, x + 20 + width + (int)this.offsetX, y + (32 * o - 14) + (int)this.offsetY, 30, 166, 3, 28);
            pGuiGraphics.blit(TEXTURE, x + 18 + (int)this.offsetX, y + (32 * o - 14) + (int)this.offsetY, 30, 166, 3, 28);
            Font font = Minecraft.getInstance().font;
            String string = ((Integer)i.getKey()).toString();
            int n = x + 13 + (int)this.offsetX;
            int n2 = y + (int)this.offsetY + 32 * o;
            Objects.requireNonNull(Minecraft.getInstance().font);
            pGuiGraphics.drawCenteredString(font, string, n, n2 - 9 / 2, -3601013);
            ++o;
        }
    }
}

