/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.screen;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.computer.ComputerFile;
import com.cmdpro.datanessence.api.computer.ComputerFileType;
import com.cmdpro.datanessence.data.computers.ClientComputerData;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ComputerScreen
extends Screen {
    public ComputerFile file;
    public static int imageWidth = 256;
    public static int imageHeight = 166;
    public static final ResourceLocation TEXTURE = DataNEssence.locate("textures/gui/computer.png");

    public ComputerScreen(Component pTitle) {
        super(pTitle);
    }

    public void tick() {
        super.tick();
        if (this.file != null) {
            this.file.getType().tick(this.file);
        }
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.file != null) {
            if (pButton == 1) {
                this.file = null;
                return true;
            }
            this.file.getType().mouseClicked(this.file, pMouseX, pMouseY, pButton);
            return true;
        }
        int x = (this.width - imageWidth) / 2;
        int y = (this.height - imageHeight) / 2;
        int x2 = 8;
        int y2 = 8;
        for (ComputerFile i : ClientComputerData.clientComputerData.files) {
            ComputerFileType.ComputerFileIcon icon = i.getType().getIcon(i);
            if (pMouseX >= (double)(x + x2 + 2) && pMouseY >= (double)(y + y2 + 2) && pMouseX <= (double)(x + x2 + 2 + icon.width) && pMouseY <= (double)(y + y2 + 2 + icon.height)) {
                this.file = i;
                return true;
            }
            if ((x2 += icon.width + 4) < imageWidth - 8) continue;
            x2 = 8;
            y2 += icon.height + 4;
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.file != null) {
            this.file.getType().mouseDragged(this.file, pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        if (this.file != null) {
            this.file.getType().mouseReleased(this.file, pMouseX, pMouseY, pButton);
        }
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.file != null) {
            this.file.getType().keyPressed(this.file, pKeyCode, pScanCode, pModifiers);
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    public void onClose() {
        if (this.file == null) {
            super.onClose();
        } else {
            this.file = null;
        }
    }

    public boolean keyReleased(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.file != null) {
            this.file.getType().keyReleased(this.file, pKeyCode, pScanCode, pModifiers);
        }
        return super.keyReleased(pKeyCode, pScanCode, pModifiers);
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.width - imageWidth) / 2;
        int y = (this.height - imageHeight) / 2;
        pGuiGraphics.blit(TEXTURE, x, y, 0, 0, imageWidth, imageHeight);
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderBg(pGuiGraphics, pPartialTick, pMouseX, pMouseY);
        int x = (this.width - imageWidth) / 2;
        int y = (this.height - imageHeight) / 2;
        if (this.file != null) {
            this.file.getType().renderScreen(this.file, pGuiGraphics, pMouseX, pMouseY, pPartialTick, x, y);
        } else {
            int x2 = 8;
            int y2 = 8;
            for (ComputerFile i : ClientComputerData.clientComputerData.files) {
                ComputerFileType.ComputerFileIcon icon = i.getType().getIcon(i);
                pGuiGraphics.blit(icon.location, x + x2 + 2, y + y2 + 2, icon.u, icon.v, icon.width, icon.height);
                if (pMouseX >= x + x2 + 2 && pMouseY >= y + y2 + 2 && pMouseX <= x + x2 + 2 + icon.width && pMouseY <= y + y2 + 2 + icon.height) {
                    pGuiGraphics.fill(x + x2, y + y2, x + x2 + 4 + icon.width, y + y2 + 4 + icon.height, -1426063361);
                }
                if ((x2 += icon.width + 4) < imageWidth - 8) continue;
                x2 = 8;
                y2 += icon.height + 4;
            }
        }
        pGuiGraphics.blit(TEXTURE, x + 3, y + 3, 48, 166, 4, 4);
        pGuiGraphics.blit(TEXTURE, x + 3, y + imageHeight - 7, 48, 170, 4, 4);
        pGuiGraphics.blit(TEXTURE, x + imageWidth - 7, y + 3, 52, 166, 4, 4);
        pGuiGraphics.blit(TEXTURE, x + imageWidth - 7, y + imageHeight - 7, 52, 170, 4, 4);
    }
}

