/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.registry;

import com.cmdpro.datanessence.recipe.DryingRecipe;
import com.cmdpro.datanessence.recipe.EntropicProcessingRecipe;
import com.cmdpro.datanessence.recipe.FluidMixingRecipe;
import com.cmdpro.datanessence.recipe.GenderfluidTransitionRecipe;
import com.cmdpro.datanessence.recipe.IFabricationRecipe;
import com.cmdpro.datanessence.recipe.InfusionRecipe;
import com.cmdpro.datanessence.recipe.MeltingRecipe;
import com.cmdpro.datanessence.recipe.MetalShaperRecipe;
import com.cmdpro.datanessence.recipe.MineralPurificationRecipe;
import com.cmdpro.datanessence.recipe.ShapedFabricationRecipe;
import com.cmdpro.datanessence.recipe.ShapelessFabricationRecipe;
import com.cmdpro.datanessence.recipe.SynthesisRecipe;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class RecipeRegistry {
    public static final DeferredRegister<RecipeSerializer<?>> RECIPES = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"datanessence");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_TYPE, (String)"datanessence");
    public static final Supplier<RecipeSerializer<ShapelessFabricationRecipe>> SHAPELESSFABRICATIONRECIPE = RecipeRegistry.registerSerializer("shapeless_fabrication_recipe", () -> ShapelessFabricationRecipe.Serializer.INSTANCE);
    public static final Supplier<RecipeSerializer<ShapedFabricationRecipe>> SHAPEDFABRICATIONRECIPE = RecipeRegistry.registerSerializer("shaped_fabrication_recipe", () -> ShapedFabricationRecipe.Serializer.INSTANCE);
    public static final Supplier<RecipeSerializer<InfusionRecipe>> INFUSION = RecipeRegistry.registerSerializer("infusion", () -> InfusionRecipe.Serializer.INSTANCE);
    public static final Supplier<RecipeSerializer<EntropicProcessingRecipe>> ENTROPIC_PROCESSING = RecipeRegistry.registerSerializer("entropic_processing", () -> EntropicProcessingRecipe.Serializer.INSTANCE);
    public static final Supplier<RecipeSerializer<SynthesisRecipe>> SYNTHESIS = RecipeRegistry.registerSerializer("synthesis", () -> SynthesisRecipe.Serializer.INSTANCE);
    public static final Supplier<RecipeSerializer<FluidMixingRecipe>> FLUID_MIXING = RecipeRegistry.registerSerializer("fluid_mixing", () -> FluidMixingRecipe.Serializer.INSTANCE);
    public static final Supplier<RecipeSerializer<MineralPurificationRecipe>> MINERAL_PURIFICATION = RecipeRegistry.registerSerializer("mineral_purification", () -> MineralPurificationRecipe.Serializer.INSTANCE);
    public static final Supplier<RecipeSerializer<MetalShaperRecipe>> METAL_SHAPING = RecipeRegistry.registerSerializer("metal_shaping", () -> MetalShaperRecipe.Serializer.INSTANCE);
    public static final Supplier<RecipeSerializer<MeltingRecipe>> MELTING = RecipeRegistry.registerSerializer("melting", () -> MeltingRecipe.Serializer.INSTANCE);
    public static final Supplier<RecipeSerializer<DryingRecipe>> DRYING = RecipeRegistry.registerSerializer("drying", () -> DryingRecipe.Serializer.INSTANCE);
    public static final Supplier<RecipeSerializer<GenderfluidTransitionRecipe>> GENDERFLUID_TRANSITION = RecipeRegistry.registerSerializer("genderfluid_transition", () -> GenderfluidTransitionRecipe.Serializer.INSTANCE);
    public static final Supplier<RecipeType<FluidMixingRecipe>> FLUID_MIXING_TYPE = RecipeRegistry.registerBasicRecipeType("fluid_mixing");
    public static final Supplier<RecipeType<SynthesisRecipe>> SYNTHESIS_TYPE = RecipeRegistry.registerBasicRecipeType("synthesis");
    public static final Supplier<RecipeType<MetalShaperRecipe>> METAL_SHAPING_TYPE = RecipeRegistry.registerBasicRecipeType("metal_shaping");
    public static final Supplier<RecipeType<EntropicProcessingRecipe>> ENTROPIC_PROCESSING_TYPE = RecipeRegistry.registerBasicRecipeType("entropic_processing");
    public static final Supplier<RecipeType<InfusionRecipe>> INFUSION_TYPE = RecipeRegistry.registerBasicRecipeType("infusion");
    public static final Supplier<RecipeType<MineralPurificationRecipe>> MINERAL_PURIFICATION_TYPE = RecipeRegistry.registerBasicRecipeType("mineral_purification");
    public static final Supplier<RecipeType<IFabricationRecipe>> FABRICATIONCRAFTING = RecipeRegistry.registerBasicRecipeType("fabrication_recipe");
    public static final Supplier<RecipeType<MeltingRecipe>> MELTING_TYPE = RecipeRegistry.registerBasicRecipeType("melting");
    public static final Supplier<RecipeType<DryingRecipe>> DRYING_TYPE = RecipeRegistry.registerBasicRecipeType("drying");
    public static final Supplier<RecipeType<GenderfluidTransitionRecipe>> GENDERFLUID_TRANSITION_TYPE = RecipeRegistry.registerBasicRecipeType("genderfluid_transition");

    private static <T extends RecipeType<?>> Supplier<T> registerType(String name, Supplier<T> recipe) {
        return RECIPE_TYPES.register(name, recipe);
    }

    static <T extends Recipe<?>> DeferredHolder<RecipeType<?>, RecipeType<T>> registerBasicRecipeType(final String id) {
        return RECIPE_TYPES.register(id, () -> new RecipeType<T>(){

            public String toString() {
                return id;
            }
        });
    }

    private static <T extends RecipeSerializer<?>> Supplier<T> registerSerializer(String name, Supplier<T> recipe) {
        return RECIPES.register(name, recipe);
    }
}

