/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.registry;

import com.cmdpro.datanessence.client.particle.CircleParticleOptions;
import com.cmdpro.datanessence.client.particle.MoteParticleOptions;
import com.cmdpro.datanessence.client.particle.RhombusParticleOptions;
import com.cmdpro.datanessence.client.particle.SmallCircleParticleOptions;
import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ParticleRegistry {
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.PARTICLE_TYPE, (String)"datanessence");
    public static final Supplier<SimpleParticleType> ESSENCE_SPARKLE = ParticleRegistry.register("essence_sparkle", () -> new SimpleParticleType(false));
    public static final Supplier<ParticleType> CIRCLE = ParticleRegistry.register("circle", () -> new ParticleType<CircleParticleOptions>(false){

        public MapCodec<CircleParticleOptions> codec() {
            return CircleParticleOptions.CODEC;
        }

        public StreamCodec<? super RegistryFriendlyByteBuf, CircleParticleOptions> streamCodec() {
            return CircleParticleOptions.STREAM_CODEC;
        }
    });
    public static final Supplier<ParticleType> RHOMBUS = ParticleRegistry.register("rhombus", () -> new ParticleType<RhombusParticleOptions>(false){

        public MapCodec<RhombusParticleOptions> codec() {
            return RhombusParticleOptions.CODEC;
        }

        public StreamCodec<? super RegistryFriendlyByteBuf, RhombusParticleOptions> streamCodec() {
            return RhombusParticleOptions.STREAM_CODEC;
        }
    });
    public static final Supplier<ParticleType> MOTE = ParticleRegistry.register("mote", () -> new ParticleType<MoteParticleOptions>(false){

        public MapCodec<MoteParticleOptions> codec() {
            return MoteParticleOptions.CODEC;
        }

        public StreamCodec<? super RegistryFriendlyByteBuf, MoteParticleOptions> streamCodec() {
            return MoteParticleOptions.STREAM_CODEC;
        }
    });
    public static final Supplier<ParticleType> SMALL_CIRCLE = ParticleRegistry.register("small_circle", () -> new ParticleType<SmallCircleParticleOptions>(false){

        public MapCodec<SmallCircleParticleOptions> codec() {
            return SmallCircleParticleOptions.CODEC;
        }

        public StreamCodec<? super RegistryFriendlyByteBuf, SmallCircleParticleOptions> streamCodec() {
            return SmallCircleParticleOptions.STREAM_CODEC;
        }
    });

    private static <T extends ParticleType<?>> Supplier<T> register(String name, Supplier<T> particle) {
        return PARTICLE_TYPES.register(name, particle);
    }
}

