/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.registry;

import com.cmdpro.datanessence.api.DataNEssenceRegistries;
import com.cmdpro.datanessence.api.databank.MinigameSerializer;
import com.cmdpro.datanessence.data.minigames.ColorMixingMinigameCreator;
import com.cmdpro.datanessence.data.minigames.LaserMinigameCreator;
import com.cmdpro.datanessence.data.minigames.MinesweeperMinigameCreator;
import com.cmdpro.datanessence.data.minigames.TracesMinigameCreator;
import com.cmdpro.datanessence.data.minigames.WireMinigameCreator;
import java.util.function.Supplier;
import net.neoforged.neoforge.registries.DeferredRegister;

public class MinigameRegistry {
    public static final DeferredRegister<MinigameSerializer> MINIGAME_TYPES = DeferredRegister.create(DataNEssenceRegistries.MINIGAME_TYPE_REGISTRY_KEY, (String)"datanessence");
    public static final Supplier<MinigameSerializer> MINESWEEPER = MinigameRegistry.register("minesweeper", () -> new MinesweeperMinigameCreator.MinesweeperMinigameSerializer());
    public static final Supplier<MinigameSerializer> WIRE = MinigameRegistry.register("wire", () -> new WireMinigameCreator.WireMinigameSerializer());
    public static final Supplier<MinigameSerializer> TRACES = MinigameRegistry.register("traces", () -> new TracesMinigameCreator.TracesMinigameSerializer());
    public static final Supplier<MinigameSerializer> COLOR_MIXING = MinigameRegistry.register("color_mixing", () -> new ColorMixingMinigameCreator.ColorMixingMinigameSerializer());
    public static final Supplier<MinigameSerializer> LASER = MinigameRegistry.register("laser", () -> new LaserMinigameCreator.LaserMinigameSerializer());

    private static <T extends MinigameSerializer> Supplier<T> register(String name, Supplier<T> item) {
        return MINIGAME_TYPES.register(name, item);
    }
}

