/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.registry;

import com.cmdpro.datanessence.DataNEssence;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingShieldBlockEvent;

@EventBusSubscriber(modid="datanessence")
public class DamageTypeRegistry {
    public static final ResourceKey<DamageType> magicProjectile = DamageTypeRegistry.damageType("magic_projectile");
    public static final ResourceKey<DamageType> laser = DamageTypeRegistry.damageType("laser");
    public static final ResourceKey<DamageType> blackHole = DamageTypeRegistry.damageType("black_hole");
    public static final ResourceKey<DamageType> essenceSiphoned = DamageTypeRegistry.damageType("essence_siphoned");
    public static final ResourceKey<DamageType> crushed = DamageTypeRegistry.damageType("crushed");
    public static final ResourceKey<DamageType> ancientProjectile = DamageTypeRegistry.damageType("ancient_projectile");

    private static ResourceKey<DamageType> damageType(String name) {
        return ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)DataNEssence.locate(name));
    }

    @SubscribeEvent
    public static void onLivingEntityTick(LivingDamageEvent.Pre event) {
        if (event.getSource().is(ancientProjectile)) {
            event.setNewDamage(event.getContainer().getOriginalDamage());
        }
    }

    @SubscribeEvent
    public static void onBlock(LivingShieldBlockEvent event) {
        if (event.getDamageSource().is(ancientProjectile)) {
            event.setBlocked(false);
        }
    }
}

