/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.registry;

import com.cmdpro.datanessence.api.misc.BlockPosNetworks;
import com.cmdpro.datanessence.block.technical.StructureProtectorBlockEntity;
import com.cmdpro.datanessence.item.equipment.GrapplingHook;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public class AttachmentTypeRegistry {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"datanessence");
    public static final Supplier<AttachmentType<ArrayList<StructureProtectorBlockEntity>>> STRUCTURE_CONTROLLERS = AttachmentTypeRegistry.register("structure_controllers", () -> AttachmentType.builder(() -> new ArrayList()).build());
    public static final Supplier<AttachmentType<BlockPosNetworks>> ESSENCE_NODE_NETWORKS = AttachmentTypeRegistry.register("essence_node_networks", () -> AttachmentType.builder(() -> new BlockPosNetworks((DefaultDirectedGraph<BlockPos, DefaultEdge>)new DefaultDirectedGraph(DefaultEdge.class))).serialize(BlockPosNetworks.CODEC).build());
    public static final Supplier<AttachmentType<BlockPosNetworks>> CAPABILITY_NODE_NETWORKS = AttachmentTypeRegistry.register("capability_node_networks", () -> AttachmentType.builder(() -> new BlockPosNetworks((DefaultDirectedGraph<BlockPos, DefaultEdge>)new DefaultDirectedGraph(DefaultEdge.class))).serialize(BlockPosNetworks.CODEC).build());
    public static final Supplier<AttachmentType<BlockPosNetworks>> ENDER_PEARL_NETWORKS = AttachmentTypeRegistry.register("ender_pearl_networks", () -> AttachmentType.builder(() -> new BlockPosNetworks((DefaultDirectedGraph<BlockPos, DefaultEdge>)new DefaultDirectedGraph(DefaultEdge.class))).serialize(BlockPosNetworks.CODEC).build());
    public static final Supplier<AttachmentType<Integer>> TIER = AttachmentTypeRegistry.register("tier", () -> AttachmentType.builder(() -> 0).serialize((Codec)Codec.INT).copyOnDeath().build());
    public static final Supplier<AttachmentType<Optional<BlockEntity>>> LINK_FROM = AttachmentTypeRegistry.register("link_from", () -> AttachmentType.builder(() -> Optional.ofNullable(null)).build());
    public static final Supplier<AttachmentType<Optional<GrapplingHook.GrapplingHookData>>> GRAPPLING_HOOK_DATA = AttachmentTypeRegistry.register("grappling_hook_data", () -> AttachmentType.builder(() -> Optional.ofNullable(null)).build());
    public static final Supplier<AttachmentType<Optional<StructureProtectorBlockEntity>>> BINDING_STRUCTURE_CONTROLLER = AttachmentTypeRegistry.register("binding_structure_controller", () -> AttachmentType.builder(() -> Optional.ofNullable(null)).build());
    public static final Supplier<AttachmentType<HashMap<ResourceLocation, Boolean>>> UNLOCKED_ESSENCES = AttachmentTypeRegistry.register("unlocked_essences", () -> AttachmentType.builder(() -> new HashMap()).serialize(Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)Codec.BOOL).xmap(HashMap::new, HashMap::new)).copyOnDeath().build());
    public static final Supplier<AttachmentType<Boolean>> HAS_HORNS = AttachmentTypeRegistry.register("has_horns", () -> AttachmentType.builder(() -> false).serialize((Codec)Codec.BOOL).copyOnDeath().build());
    public static final Supplier<AttachmentType<Boolean>> HAS_TAIL = AttachmentTypeRegistry.register("has_tail", () -> AttachmentType.builder(() -> false).serialize((Codec)Codec.BOOL).copyOnDeath().build());
    public static final Supplier<AttachmentType<Boolean>> HAS_WINGS = AttachmentTypeRegistry.register("has_wings", () -> AttachmentType.builder(() -> false).serialize((Codec)Codec.BOOL).copyOnDeath().build());
    public static final Supplier<AttachmentType<ArrayList<ResourceLocation>>> UNLOCKED = AttachmentTypeRegistry.register("unlocked", () -> AttachmentType.builder(() -> new ArrayList()).serialize(ResourceLocation.CODEC.listOf().xmap(ArrayList::new, a -> a.stream().toList())).copyOnDeath().build());
    public static final Supplier<AttachmentType<HashMap<ResourceLocation, Integer>>> INCOMPLETE_STAGES = AttachmentTypeRegistry.register("incomplete_stages", () -> AttachmentType.builder(() -> new HashMap()).serialize(Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)Codec.INT).xmap(HashMap::new, a -> a)).copyOnDeath().build());

    private static <T extends AttachmentType<?>> Supplier<T> register(String name, Supplier<T> attachment) {
        return ATTACHMENT_TYPES.register(name, attachment);
    }
}

