/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.recipe;

import com.cmdpro.datanessence.recipe.IHasEssenceCost;
import com.cmdpro.datanessence.recipe.IHasRequiredKnowledge;
import com.cmdpro.datanessence.registry.RecipeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class SynthesisRecipe
implements Recipe<RecipeInput>,
IHasEssenceCost,
IHasRequiredKnowledge {
    private final ItemStack output;
    private final Ingredient input;
    private final Ingredient input2;
    private final int time;
    private final Map<ResourceLocation, Float> essenceCost;
    private final ResourceLocation entry;
    private final int completionStage;

    public SynthesisRecipe(ItemStack output, Ingredient input, Ingredient input2, int time, Map<ResourceLocation, Float> essenceCost, ResourceLocation entry, int completionStage) {
        this.output = output;
        this.input = input;
        this.input2 = input2;
        this.time = time;
        this.essenceCost = essenceCost;
        this.entry = entry;
        this.completionStage = completionStage;
    }

    @Override
    public int getCompletionStage() {
        return this.completionStage;
    }

    @Override
    public Map<ResourceLocation, Float> getEssenceCost() {
        return this.essenceCost;
    }

    public int getTime() {
        return this.time;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.input);
        list.add((Object)this.input2);
        return list;
    }

    public boolean matches(RecipeInput pContainer, Level pLevel) {
        return this.input.test(pContainer.getItem(0)) && this.input2.test(pContainer.getItem(1));
    }

    public ItemStack assemble(RecipeInput pContainer, HolderLookup.Provider pRegistryAccess) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider pRegistryAccess) {
        return this.output;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return RecipeRegistry.SYNTHESIS_TYPE.get();
    }

    @Override
    public ResourceLocation getEntry() {
        return this.entry;
    }

    public static class Serializer
    implements RecipeSerializer<SynthesisRecipe> {
        public static final MapCodec<SynthesisRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("result").forGetter(r -> r.output), (App)Ingredient.CODEC.fieldOf("input").forGetter(r -> r.input), (App)Ingredient.CODEC.fieldOf("input2").forGetter(r -> r.input2), (App)Codec.INT.fieldOf("time").forGetter(r -> r.time), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)Codec.FLOAT).fieldOf("essenceCost").forGetter(r -> r.essenceCost), (App)ResourceLocation.CODEC.fieldOf("entry").forGetter(r -> r.entry), (App)Codec.INT.optionalFieldOf("completion_stage", (Object)-1).forGetter(r -> r.completionStage)).apply((Applicative)instance, SynthesisRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SynthesisRecipe> STREAM_CODEC = StreamCodec.of((buf, obj) -> {
            ItemStack.STREAM_CODEC.encode(buf, (Object)obj.output);
            Ingredient.CONTENTS_STREAM_CODEC.encode(buf, (Object)obj.input);
            Ingredient.CONTENTS_STREAM_CODEC.encode(buf, (Object)obj.input2);
            buf.writeInt(obj.time);
            buf.writeMap(obj.essenceCost, FriendlyByteBuf::writeResourceLocation, FriendlyByteBuf::writeFloat);
            buf.writeResourceLocation(obj.entry);
            buf.writeInt(obj.completionStage);
        }, buf -> {
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode(buf);
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf);
            Ingredient input2 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf);
            int time = buf.readInt();
            Map essenceCost = buf.readMap(FriendlyByteBuf::readResourceLocation, FriendlyByteBuf::readFloat);
            ResourceLocation entry = buf.readResourceLocation();
            int completionStage = buf.readInt();
            return new SynthesisRecipe(output, input, input2, time, essenceCost, entry, completionStage);
        });
        public static final Serializer INSTANCE = new Serializer();

        public MapCodec<SynthesisRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SynthesisRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

