/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.recipe;

import com.cmdpro.datanessence.recipe.IFabricationRecipe;
import com.cmdpro.datanessence.registry.RecipeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;

public class ShapelessFabricationRecipe
implements IFabricationRecipe {
    private final Map<ResourceLocation, Float> essenceCost;
    private final ResourceLocation entry;
    private final int completionStage;
    final ItemStack result;
    final NonNullList<Ingredient> ingredients;
    private final boolean isSimple;
    final int time;

    public ShapelessFabricationRecipe(ItemStack result, NonNullList<Ingredient> ingredients, ResourceLocation entry, int completionStage, Map<ResourceLocation, Float> essenceCost, int time) {
        this.entry = entry;
        this.completionStage = completionStage;
        this.essenceCost = essenceCost;
        this.result = result;
        this.ingredients = ingredients;
        this.isSimple = ingredients.stream().allMatch(Ingredient::isSimple);
        this.time = time;
    }

    @Override
    public int getCompletionStage() {
        return this.completionStage;
    }

    public ItemStack getResultItem(HolderLookup.Provider pRegistryAccess) {
        return this.result;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public boolean matches(CraftingInput pInv, Level pLevel) {
        StackedContents stackedcontents = new StackedContents();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < pInv.size(); ++j) {
            ItemStack itemstack = pInv.getItem(j);
            if (itemstack.isEmpty()) continue;
            ++i;
            if (this.isSimple) {
                stackedcontents.accountStack(itemstack, 1);
                continue;
            }
            inputs.add(itemstack);
        }
        return i == this.ingredients.size() && (this.isSimple ? stackedcontents.canCraft((Recipe)this, null) : RecipeMatcher.findMatches(inputs, this.ingredients) != null);
    }

    public ItemStack assemble(CraftingInput p_345149_, HolderLookup.Provider p_346030_) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth * pHeight >= this.ingredients.size();
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @Override
    public RecipeType<?> getType() {
        return RecipeRegistry.FABRICATIONCRAFTING.get();
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public ResourceLocation getEntry() {
        return this.entry;
    }

    @Override
    public Map<ResourceLocation, Float> getEssenceCost() {
        return this.essenceCost;
    }

    public static class Serializer
    implements RecipeSerializer<ShapelessFabricationRecipe> {
        public static final MapCodec<ShapelessFabricationRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("result").forGetter(p_301142_ -> p_301142_.result), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(p_301021_ -> {
            Object[] aingredient = (Ingredient[])p_301021_.toArray(Ingredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return aingredient.length > ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth() ? DataResult.error(() -> "Too many ingredients for shapeless recipe. The maximum is: %s".formatted(ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth())) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
        }, DataResult::success).forGetter(p_300975_ -> p_300975_.ingredients), (App)ResourceLocation.CODEC.fieldOf("entry").forGetter(r -> r.entry), (App)Codec.INT.optionalFieldOf("completion_stage", (Object)-1).forGetter(r -> r.completionStage), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)Codec.FLOAT).fieldOf("essenceCost").forGetter(r -> r.essenceCost), (App)Codec.INT.optionalFieldOf("time", (Object)20).forGetter(r -> r.time)).apply((Applicative)instance, ShapelessFabricationRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapelessFabricationRecipe> STREAM_CODEC = StreamCodec.of((buf, obj) -> {
            buf.writeVarInt(obj.ingredients.size());
            for (Ingredient ingredient : obj.ingredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode(buf, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode(buf, (Object)obj.result);
            buf.writeResourceLocation(obj.entry);
            buf.writeInt(obj.completionStage);
            buf.writeMap(obj.essenceCost, FriendlyByteBuf::writeResourceLocation, FriendlyByteBuf::writeFloat);
            buf.writeInt(obj.time);
        }, buf -> {
            int i = buf.readVarInt();
            NonNullList nonnulllist = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            nonnulllist.replaceAll(p_319735_ -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf));
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode(buf);
            ResourceLocation entry = buf.readResourceLocation();
            int completionStage = buf.readInt();
            Map essenceCost = buf.readMap(FriendlyByteBuf::readResourceLocation, FriendlyByteBuf::readFloat);
            int time = buf.readInt();
            return new ShapelessFabricationRecipe(itemstack, (NonNullList<Ingredient>)nonnulllist, entry, completionStage, essenceCost, time);
        });
        public static final Serializer INSTANCE = new Serializer();

        public MapCodec<ShapelessFabricationRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ShapelessFabricationRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

