/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.recipe;

import com.cmdpro.datanessence.recipe.IFabricationRecipe;
import com.cmdpro.datanessence.registry.RecipeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;

public class ShapedFabricationRecipe
implements IFabricationRecipe {
    private final ResourceLocation entry;
    private final int completionStage;
    private final Map<ResourceLocation, Float> essenceCost;
    final ShapedRecipePattern pattern;
    final ItemStack result;
    final int time;

    public ShapedFabricationRecipe(ShapedRecipePattern pPattern, ItemStack pResult, ResourceLocation entry, int completionStage, Map<ResourceLocation, Float> essenceCost, int time) {
        this.entry = entry;
        this.completionStage = completionStage;
        this.essenceCost = essenceCost;
        this.pattern = pPattern;
        this.result = pResult;
        this.time = time;
    }

    @Override
    public int getCompletionStage() {
        return this.completionStage;
    }

    public ItemStack getResultItem(HolderLookup.Provider pRegistryAccess) {
        return this.result;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.pattern.ingredients();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth >= this.pattern.width() && pHeight >= this.pattern.height();
    }

    public boolean matches(CraftingInput pInv, Level pLevel) {
        return this.pattern.matches(pInv);
    }

    public ItemStack assemble(CraftingInput pContainer, HolderLookup.Provider pRegistryAccess) {
        return this.getResultItem(pRegistryAccess).copy();
    }

    public int getWidth() {
        return this.pattern.width();
    }

    public int getHeight() {
        return this.pattern.height();
    }

    public boolean isIncomplete() {
        NonNullList<Ingredient> nonnulllist = this.getIngredients();
        return nonnulllist.isEmpty() || nonnulllist.stream().filter(p_151277_ -> !p_151277_.isEmpty()).anyMatch(Ingredient::hasNoItems);
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @Override
    public RecipeType<?> getType() {
        return RecipeRegistry.FABRICATIONCRAFTING.get();
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public ResourceLocation getEntry() {
        return this.entry;
    }

    @Override
    public Map<ResourceLocation, Float> getEssenceCost() {
        return this.essenceCost;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedFabricationRecipe> {
        public static final MapCodec<ShapedFabricationRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ShapedRecipePattern.MAP_CODEC.forGetter(p_311733_ -> p_311733_.pattern), (App)ItemStack.CODEC.fieldOf("result").forGetter(p_311730_ -> p_311730_.result), (App)ResourceLocation.CODEC.fieldOf("entry").forGetter(r -> r.entry), (App)Codec.INT.optionalFieldOf("completion_stage", (Object)-1).forGetter(r -> r.completionStage), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)Codec.FLOAT).fieldOf("essenceCost").forGetter(r -> r.essenceCost), (App)Codec.INT.optionalFieldOf("time", (Object)20).forGetter(r -> r.time)).apply((Applicative)instance, ShapedFabricationRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapedFabricationRecipe> STREAM_CODEC = StreamCodec.of((buf, obj) -> {
            ShapedRecipePattern.STREAM_CODEC.encode(buf, (Object)obj.pattern);
            ItemStack.STREAM_CODEC.encode(buf, (Object)obj.result);
            buf.writeResourceLocation(obj.entry);
            buf.writeInt(obj.completionStage);
            buf.writeMap(obj.essenceCost, FriendlyByteBuf::writeResourceLocation, FriendlyByteBuf::writeFloat);
            buf.writeInt(obj.time);
        }, buf -> {
            ShapedRecipePattern shapedrecipepattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode(buf);
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode(buf);
            ResourceLocation entry = buf.readResourceLocation();
            int completionStage = buf.readInt();
            Map essenceCost = buf.readMap(FriendlyByteBuf::readResourceLocation, FriendlyByteBuf::readFloat);
            int time = buf.readInt();
            return new ShapedFabricationRecipe(shapedrecipepattern, itemstack, entry, completionStage, essenceCost, time);
        });
        public static final Serializer INSTANCE = new Serializer();

        public MapCodec<ShapedFabricationRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ShapedFabricationRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

