/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.recipe;

import com.cmdpro.datanessence.recipe.IHasEssenceCost;
import com.cmdpro.datanessence.recipe.IHasRequiredKnowledge;
import com.cmdpro.datanessence.registry.RecipeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class InfusionRecipe
implements IHasEssenceCost,
IHasRequiredKnowledge,
Recipe<RecipeInput> {
    private final ItemStack output;
    private final Ingredient input;
    private final ResourceLocation entry;
    private final int completionStage;
    private final Map<ResourceLocation, Float> essenceCost;

    public InfusionRecipe(ItemStack output, Ingredient input, ResourceLocation entry, int completionStage, Map<ResourceLocation, Float> essenceCost) {
        this.output = output;
        this.input = input;
        this.entry = entry;
        this.completionStage = completionStage;
        this.essenceCost = essenceCost;
    }

    @Override
    public Map<ResourceLocation, Float> getEssenceCost() {
        return this.essenceCost;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.input);
        return list;
    }

    public boolean matches(RecipeInput pContainer, Level pLevel) {
        return this.input.test(pContainer.getItem(0));
    }

    public ItemStack assemble(RecipeInput pContainer, HolderLookup.Provider pRegistryAccess) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider pRegistryAccess) {
        return this.output;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return RecipeRegistry.INFUSION_TYPE.get();
    }

    @Override
    public ResourceLocation getEntry() {
        return this.entry;
    }

    @Override
    public int getCompletionStage() {
        return this.completionStage;
    }

    public static class Serializer
    implements RecipeSerializer<InfusionRecipe> {
        public static final MapCodec<InfusionRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("result").forGetter(r -> r.output), (App)Ingredient.CODEC.fieldOf("input").forGetter(r -> r.input), (App)ResourceLocation.CODEC.fieldOf("entry").forGetter(r -> r.entry), (App)Codec.INT.optionalFieldOf("completion_stage", (Object)-1).forGetter(r -> r.completionStage), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)Codec.FLOAT).fieldOf("essenceCost").forGetter(r -> r.essenceCost)).apply((Applicative)instance, InfusionRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, InfusionRecipe> STREAM_CODEC = StreamCodec.of((buf, obj) -> {
            ItemStack.STREAM_CODEC.encode(buf, (Object)obj.output);
            Ingredient.CONTENTS_STREAM_CODEC.encode(buf, (Object)obj.input);
            buf.writeResourceLocation(obj.entry);
            buf.writeInt(obj.completionStage);
            buf.writeMap(obj.essenceCost, FriendlyByteBuf::writeResourceLocation, FriendlyByteBuf::writeFloat);
        }, buf -> {
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode(buf);
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf);
            ResourceLocation entry = buf.readResourceLocation();
            int completionStage = buf.readInt();
            Map essenceCost = buf.readMap(FriendlyByteBuf::readResourceLocation, FriendlyByteBuf::readFloat);
            return new InfusionRecipe(output, input, entry, completionStage, essenceCost);
        });
        public static final Serializer INSTANCE = new Serializer();

        public MapCodec<InfusionRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, InfusionRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

