/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.recipe;

import com.cmdpro.datanessence.registry.RecipeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class GenderfluidTransitionRecipe
implements Recipe<RecipeInput> {
    private final ItemStack output;
    private final Ingredient input;
    private final boolean mergeComponents;

    public GenderfluidTransitionRecipe(ItemStack output, Ingredient input, boolean mergeComponents) {
        this.output = output;
        this.input = input;
        this.mergeComponents = mergeComponents;
    }

    public boolean getMergeComponents() {
        return this.mergeComponents;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.input);
        return list;
    }

    public boolean matches(RecipeInput pContainer, Level pLevel) {
        return this.input.test(pContainer.getItem(0));
    }

    public ItemStack assemble(RecipeInput pContainer, HolderLookup.Provider pRegistryAccess) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider pRegistryAccess) {
        return this.output;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return RecipeRegistry.GENDERFLUID_TRANSITION_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<GenderfluidTransitionRecipe> {
        public static final MapCodec<GenderfluidTransitionRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("result").forGetter(r -> r.output), (App)Ingredient.CODEC.fieldOf("input").forGetter(r -> r.input), (App)Codec.BOOL.optionalFieldOf("mergeComponents", (Object)true).forGetter(r -> r.mergeComponents)).apply((Applicative)instance, GenderfluidTransitionRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, GenderfluidTransitionRecipe> STREAM_CODEC = StreamCodec.of((buf, obj) -> {
            ItemStack.STREAM_CODEC.encode(buf, (Object)obj.output);
            Ingredient.CONTENTS_STREAM_CODEC.encode(buf, (Object)obj.input);
            buf.writeBoolean(obj.mergeComponents);
        }, buf -> {
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode(buf);
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf);
            boolean mergeComponents = buf.readBoolean();
            return new GenderfluidTransitionRecipe(output, input, mergeComponents);
        });
        public static final Serializer INSTANCE = new Serializer();

        public MapCodec<GenderfluidTransitionRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, GenderfluidTransitionRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

