/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.recipe;

import com.cmdpro.datanessence.recipe.RecipeInputWithFluid;
import com.cmdpro.datanessence.registry.RecipeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class DryingRecipe
implements Recipe<RecipeInputWithFluid> {
    private final FluidStack input;
    private final ItemStack output;
    private final Optional<Ingredient> additive;
    private final int time;

    public DryingRecipe(FluidStack input, ItemStack output, Optional<Ingredient> additive, int time) {
        this.input = input;
        this.output = output;
        this.additive = additive;
        this.time = time;
    }

    public int getTime() {
        return this.time;
    }

    public FluidStack getInput() {
        return this.input;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        this.additive.ifPresent(arg_0 -> list.add(arg_0));
        return list;
    }

    public boolean matches(RecipeInputWithFluid input, Level level) {
        return FluidStack.isSameFluidSameComponents((FluidStack)this.input, (FluidStack)input.getFluid(0)) && (this.additive.isEmpty() || this.additive.get().test(input.getItem(0)));
    }

    public ItemStack assemble(RecipeInputWithFluid input, HolderLookup.Provider registries) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.output;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return RecipeRegistry.DRYING_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<DryingRecipe> {
        public static final MapCodec<DryingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidStack.CODEC.fieldOf("input").forGetter(r -> r.input), (App)ItemStack.CODEC.fieldOf("result").forGetter(r -> r.output), (App)Ingredient.CODEC.optionalFieldOf("additive").forGetter(r -> r.additive), (App)Codec.INT.fieldOf("time").forGetter(r -> r.time)).apply((Applicative)instance, DryingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, DryingRecipe> STREAM_CODEC = StreamCodec.of((buf, obj) -> {
            FluidStack.STREAM_CODEC.encode(buf, (Object)obj.input);
            ItemStack.STREAM_CODEC.encode(buf, (Object)obj.output);
            buf.writeBoolean(obj.additive.isPresent());
            obj.additive.ifPresent(ingredient -> Ingredient.CONTENTS_STREAM_CODEC.encode(buf, ingredient));
            buf.writeInt(obj.time);
        }, buf -> {
            FluidStack input = (FluidStack)FluidStack.STREAM_CODEC.decode(buf);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode(buf);
            boolean additivePresent = buf.readBoolean();
            Optional<Ingredient> additive = Optional.empty();
            if (additivePresent) {
                additive = Optional.of((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf));
            }
            int time = buf.readInt();
            return new DryingRecipe(input, result, additive, time);
        });
        public static final Serializer INSTANCE = new Serializer();

        public MapCodec<DryingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, DryingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

