/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.networking.packet.s2c.vfx;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.networking.Message;
import com.cmdpro.datanessence.registry.SoundRegistry;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PlayEnderPearlRedirectionEffect(List<BlockPos> path) implements Message
{
    public static final CustomPacketPayload.Type<PlayEnderPearlRedirectionEffect> TYPE = new CustomPacketPayload.Type(DataNEssence.locate("play_ender_pearl_redirection_effect"));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void write(RegistryFriendlyByteBuf buf, PlayEnderPearlRedirectionEffect obj) {
        buf.writeCollection(obj.path, FriendlyByteBuf::writeBlockPos);
    }

    public static PlayEnderPearlRedirectionEffect read(RegistryFriendlyByteBuf buf) {
        List path = buf.readList(FriendlyByteBuf::readBlockPos);
        return new PlayEnderPearlRedirectionEffect(path);
    }

    @Override
    public void handleClient(Minecraft minecraft, Player player, IPayloadContext ctx) {
        if (!this.path.isEmpty()) {
            int i;
            Level level = player.level();
            RandomSource random = level.getRandom();
            BlockPos start = this.path.getFirst();
            BlockPos end = this.path.getLast();
            Vec3 startCenter = start.getCenter();
            Vec3 endCenter = end.getCenter();
            level.playSound(player, startCenter.x, startCenter.y, startCenter.z, (SoundEvent)SoundRegistry.ENDER_PEARL_ABSORB.value(), SoundSource.PLAYERS);
            level.playSound(player, endCenter.x, endCenter.y, endCenter.z, SoundEvents.PLAYER_TELEPORT, SoundSource.PLAYERS);
            if (this.path.size() >= 2) {
                for (i = 0; i < this.path.size() - 1; ++i) {
                    BlockPos current = this.path.get(i);
                    BlockPos next = this.path.get(i + 1);
                    Vec3 currentCenter = current.getCenter();
                    Vec3 nextCenter = next.getCenter();
                    int maxShifts = (int)(currentCenter.distanceTo(nextCenter) / 0.25);
                    for (int j = 0; j < maxShifts; ++j) {
                        Vec3 shifted = currentCenter.lerp(nextCenter, (double)((float)j / (float)maxShifts));
                        Vec3 speed = new Vec3((double)Mth.nextFloat((RandomSource)random, (float)-0.1f, (float)0.1f), (double)Mth.nextFloat((RandomSource)random, (float)-0.1f, (float)0.1f), (double)Mth.nextFloat((RandomSource)random, (float)-0.1f, (float)0.1f));
                        level.addParticle((ParticleOptions)ParticleTypes.REVERSE_PORTAL, true, shifted.x, shifted.y, shifted.z, speed.x, speed.y, speed.z);
                    }
                }
            }
            for (i = 0; i < 32; ++i) {
                level.addParticle((ParticleOptions)ParticleTypes.REVERSE_PORTAL, true, endCenter.x, endCenter.y + random.nextDouble() * 2.0, endCenter.z, random.nextGaussian(), 0.0, random.nextGaussian());
            }
        }
    }
}

