/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.networking.packet.s2c;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.networking.Message;
import com.cmdpro.datanessence.registry.AttachmentTypeRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record DragonPartsSync(int id, boolean horns, boolean tail, boolean wings) implements Message
{
    public static final CustomPacketPayload.Type<DragonPartsSync> TYPE = new CustomPacketPayload.Type(DataNEssence.locate("dragon_parts_sync"));

    @Override
    public void handleClient(Minecraft minecraft, Player player, IPayloadContext ctx) {
        Entity entity = player.level().getEntity(this.id);
        if (entity instanceof Player) {
            Player target = (Player)entity;
            target.setData(AttachmentTypeRegistry.HAS_HORNS, (Object)this.horns);
            target.setData(AttachmentTypeRegistry.HAS_TAIL, (Object)this.tail);
            target.setData(AttachmentTypeRegistry.HAS_WINGS, (Object)this.wings);
        }
    }

    public static void write(RegistryFriendlyByteBuf pBuffer, DragonPartsSync obj) {
        pBuffer.writeInt(obj.id);
        pBuffer.writeBoolean(obj.horns);
        pBuffer.writeBoolean(obj.tail);
        pBuffer.writeBoolean(obj.wings);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static DragonPartsSync read(RegistryFriendlyByteBuf buf) {
        int id = buf.readInt();
        boolean horns = buf.readBoolean();
        boolean tail = buf.readBoolean();
        boolean wings = buf.readBoolean();
        return new DragonPartsSync(id, horns, tail, wings);
    }
}

