/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.networking.packet.c2s;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.LockableItemHandler;
import com.cmdpro.datanessence.api.misc.ILockableContainer;
import com.cmdpro.datanessence.networking.Message;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PlayerSetItemHandlerLocked(BlockPos blockPos, boolean locked) implements Message
{
    public static final CustomPacketPayload.Type<PlayerSetItemHandlerLocked> TYPE = new CustomPacketPayload.Type(DataNEssence.locate("player_set_item_handler_locked"));

    public static PlayerSetItemHandlerLocked read(RegistryFriendlyByteBuf buf) {
        BlockPos blockPos = buf.readBlockPos();
        boolean locked = buf.readBoolean();
        return new PlayerSetItemHandlerLocked(blockPos, locked);
    }

    @Override
    public void handleServer(MinecraftServer server, ServerPlayer player, IPayloadContext ctx) {
        BlockEntity blockEntity = player.level().getBlockEntity(this.blockPos);
        if (blockEntity instanceof ILockableContainer) {
            ILockableContainer lockable = (ILockableContainer)blockEntity;
            for (LockableItemHandler handler : lockable.getLockable()) {
                handler.setLocked(this.locked);
                handler.clearLockedSlots();
                if (!handler.locked) continue;
                handler.setLockedSlots();
            }
        }
    }

    public static void write(RegistryFriendlyByteBuf buf, PlayerSetItemHandlerLocked obj) {
        buf.writeBlockPos(obj.blockPos);
        buf.writeBoolean(obj.locked);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

