/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.networking.packet.c2s;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.networking.Message;
import com.cmdpro.datanessence.registry.AttachmentTypeRegistry;
import com.cmdpro.datanessence.registry.DataComponentRegistry;
import com.cmdpro.datanessence.registry.ItemRegistry;
import java.util.HashMap;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PlayerChangeDriveData(ResourceLocation entry, int completionStage, boolean offhand) implements Message
{
    public static final CustomPacketPayload.Type<PlayerChangeDriveData> TYPE = new CustomPacketPayload.Type(DataNEssence.locate("player_change_data_drive_data"));

    @Override
    public void handleServer(MinecraftServer server, ServerPlayer player, IPayloadContext ctx) {
        ItemStack stack;
        List unlocked = (List)player.getData(AttachmentTypeRegistry.UNLOCKED);
        HashMap incomplete = (HashMap)player.getData(AttachmentTypeRegistry.INCOMPLETE_STAGES);
        if ((unlocked.contains(this.entry) || incomplete.containsKey(this.entry)) && (stack = player.getItemInHand(this.offhand ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND)).is(ItemRegistry.DATA_DRIVE.get())) {
            stack.set(DataComponentRegistry.DATA_ID, (Object)this.entry);
            stack.set(DataComponentRegistry.DATA_INCOMPLETE, (Object)this.completionStage);
        }
    }

    public static PlayerChangeDriveData read(RegistryFriendlyByteBuf buf) {
        ResourceLocation entry = buf.readResourceLocation();
        int completionStage = buf.readInt();
        boolean offhand = buf.readBoolean();
        return new PlayerChangeDriveData(entry, completionStage, offhand);
    }

    public static void write(RegistryFriendlyByteBuf buf, PlayerChangeDriveData obj) {
        buf.writeResourceLocation(obj.entry);
        buf.writeInt(obj.completionStage);
        buf.writeBoolean(obj.offhand);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

