/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.item.equipment;

import com.cmdpro.datanessence.registry.SoundRegistry;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;

public class WarpCapsule
extends Item {
    public WarpCapsule(Item.Properties pProperties) {
        super(pProperties);
    }

    public int getUseDuration(ItemStack pStack, LivingEntity p_344979_) {
        return 60;
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        pPlayer.startUsingItem(pHand);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public void onUseTick(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        super.onUseTick(pLevel, pLivingEntity, pStack, pRemainingUseDuration);
        if (pLevel.isClientSide) {
            for (int i = 0; i < 10; ++i) {
                Vec3 pos = pLivingEntity.getBoundingBox().getCenter();
                Vec3 posWithOffset = pos.offsetRandom(pLivingEntity.getRandom(), 3.0f);
                Vec3 dir = pos.subtract(posWithOffset).multiply(0.05, 0.05, 0.05);
                pLevel.addParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH, posWithOffset.x, posWithOffset.y, posWithOffset.z, dir.x, dir.y, dir.z);
            }
        }
    }

    public ItemStack finishUsingItem(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        if (!pLevel.isClientSide) {
            if (pLivingEntity instanceof Player) {
                Player player = (Player)pLivingEntity;
                DimensionTransition dimensiontransition = this.findRespawnPositionAndUseSpawnBlock((ServerPlayer)player, DimensionTransition.DO_NOTHING);
                if (player.level().dimension().equals(dimensiontransition.newLevel().dimension()) && player.position().distanceTo(dimensiontransition.pos()) <= 10000.0) {
                    pLevel.playSound(null, pLivingEntity.blockPosition(), (SoundEvent)SoundRegistry.WARP_CAPSULE_USE.value(), SoundSource.PLAYERS);
                    Vec3 vec3 = dimensiontransition.pos();
                    player.teleportTo(vec3.x, vec3.y, vec3.z);
                    pLevel.playSound(null, BlockPos.containing((Position)vec3), (SoundEvent)SoundRegistry.WARP_CAPSULE_USE.value(), SoundSource.PLAYERS);
                    pStack.consume(1, (LivingEntity)player);
                } else {
                    pLevel.playSound(null, pLivingEntity.blockPosition(), (SoundEvent)SoundRegistry.WARP_CAPSULE_FAIL.value(), SoundSource.PLAYERS);
                }
            } else {
                pLevel.playSound(null, pLivingEntity.blockPosition(), (SoundEvent)SoundRegistry.WARP_CAPSULE_FAIL.value(), SoundSource.PLAYERS);
            }
        }
        return pStack;
    }

    private DimensionTransition findRespawnPositionAndUseSpawnBlock(ServerPlayer player, DimensionTransition.PostDimensionTransition pPostDimensionTransition) {
        BlockPos blockpos = player.getRespawnPosition();
        float f = player.getRespawnAngle();
        ServerLevel serverlevel = player.getServer().getLevel(player.getRespawnDimension());
        if (serverlevel != null && blockpos != null) {
            Optional<ServerPlayer.RespawnPosAngle> optional = WarpCapsule.findRespawnAndUseSpawnBlock(serverlevel, blockpos, f);
            if (optional.isPresent()) {
                ServerPlayer.RespawnPosAngle serverplayer$respawnposangle = optional.get();
                return new DimensionTransition(serverlevel, serverplayer$respawnposangle.position(), Vec3.ZERO, serverplayer$respawnposangle.yaw(), 0.0f, pPostDimensionTransition);
            }
            return DimensionTransition.missingRespawnBlock((ServerLevel)player.server.overworld(), (Entity)player, (DimensionTransition.PostDimensionTransition)pPostDimensionTransition);
        }
        return new DimensionTransition(player.server.overworld(), (Entity)player, pPostDimensionTransition);
    }

    private static Optional<ServerPlayer.RespawnPosAngle> findRespawnAndUseSpawnBlock(ServerLevel pLevel, BlockPos pPos, float pAngle) {
        BlockState blockstate = pLevel.getBlockState(pPos);
        Block block = blockstate.getBlock();
        if (block instanceof RespawnAnchorBlock && (Integer)blockstate.getValue((Property)RespawnAnchorBlock.CHARGE) > 0 && RespawnAnchorBlock.canSetSpawn((Level)pLevel)) {
            Optional optional = RespawnAnchorBlock.findStandUpPosition((EntityType)EntityType.PLAYER, (CollisionGetter)pLevel, (BlockPos)pPos);
            return optional.map(p_348139_ -> ServerPlayer.RespawnPosAngle.of((Vec3)p_348139_, (BlockPos)pPos));
        }
        if (block instanceof BedBlock && BedBlock.canSetSpawn((Level)pLevel)) {
            return BedBlock.findStandUpPosition((EntityType)EntityType.PLAYER, (CollisionGetter)pLevel, (BlockPos)pPos, (Direction)((Direction)blockstate.getValue((Property)BedBlock.FACING)), (float)pAngle).map(p_348148_ -> ServerPlayer.RespawnPosAngle.of((Vec3)p_348148_, (BlockPos)pPos));
        }
        return blockstate.getRespawnPosition(EntityType.PLAYER, (LevelReader)pLevel, pPos, pAngle);
    }
}

