/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.item.equipment;

import com.cmdpro.databank.DatabankUtils;
import com.cmdpro.databank.hidden.types.BlockHiddenType;
import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.item.ItemEssenceContainer;
import com.cmdpro.datanessence.networking.ModMessages;
import com.cmdpro.datanessence.networking.packet.s2c.AddScannedOre;
import com.cmdpro.datanessence.networking.packet.s2c.CreatePingShader;
import com.cmdpro.datanessence.registry.DataComponentRegistry;
import com.cmdpro.datanessence.registry.SoundRegistry;
import com.cmdpro.datanessence.registry.TagRegistry;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class OreScanner
extends Item {
    public static ResourceLocation FUEL_ESSENCE_TYPE = DataNEssence.locate("essence");
    public static float ESSENCE_COST = 50.0f;

    public OreScanner(Item.Properties pProperties) {
        super(pProperties.component(DataComponentRegistry.ESSENCE_STORAGE, (Object)new ItemEssenceContainer(List.of(FUEL_ESSENCE_TYPE), 1000.0f)));
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack;
        if (!pLevel.isClientSide && ItemEssenceContainer.getEssence(stack = pPlayer.getItemInHand(pUsedHand), FUEL_ESSENCE_TYPE) >= ESSENCE_COST) {
            pLevel.playSound(null, pPlayer.blockPosition(), (SoundEvent)SoundRegistry.LOCATOR_PING.value(), SoundSource.PLAYERS);
            ModMessages.sendToPlayersNear(new CreatePingShader(pPlayer.position()), (ServerLevel)pLevel, pPlayer.position(), 128.0f);
            AABB bounds = AABB.ofSize((Vec3)pPlayer.getBoundingBox().getCenter(), (double)32.0, (double)32.0, (double)32.0);
            HashMap<BlockPos, Integer> ores = new HashMap<BlockPos, Integer>();
            for (BlockPos i : BlockPos.betweenClosed((BlockPos)BlockPos.containing((Position)bounds.getMinPosition()), (BlockPos)BlockPos.containing((Position)bounds.getMaxPosition()))) {
                BlockState state = pLevel.getBlockState(i);
                Block hiddenBlock = BlockHiddenType.getHiddenBlock((Block)state.getBlock(), (Player)pPlayer);
                if (hiddenBlock != null) {
                    state = DatabankUtils.changeBlockType((BlockState)state, (Block)hiddenBlock);
                }
                if (!state.is(TagRegistry.Blocks.SCANNABLE_ORES)) continue;
                ores.put(new BlockPos((Vec3i)i), (int)(bounds.getCenter().distanceTo(i.getCenter()) * 2.0));
            }
            ModMessages.sendToPlayer(new AddScannedOre(ores), (ServerPlayer)pPlayer);
            pPlayer.getCooldowns().addCooldown((Item)this, 200);
            ItemEssenceContainer.removeEssence(stack, FUEL_ESSENCE_TYPE, ESSENCE_COST);
        }
        return InteractionResultHolder.sidedSuccess((Object)pPlayer.getItemInHand(pUsedHand), (boolean)pLevel.isClientSide);
    }
}

