/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.item.equipment;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.item.ItemEssenceContainer;
import com.cmdpro.datanessence.registry.BlockRegistry;
import com.cmdpro.datanessence.registry.DataComponentRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class IlluminationRod
extends Item {
    public float useCost = 25.0f;
    public static ResourceLocation FUEL_ESSENCE_TYPE = DataNEssence.locate("essence");

    public IlluminationRod(Item.Properties properties) {
        super(properties.component(DataComponentRegistry.ESSENCE_STORAGE, (Object)new ItemEssenceContainer(List.of(FUEL_ESSENCE_TYPE), 5000.0f)));
    }

    public boolean placeLight(Level world, BlockPos target, ItemStack stack) {
        BlockState targetState = world.getBlockState(target);
        if (targetState.isAir() && ItemEssenceContainer.getEssence(stack, FUEL_ESSENCE_TYPE) >= this.useCost) {
            world.setBlock(target, BlockRegistry.FLARE_LIGHT.get().defaultBlockState(), 3);
            ItemEssenceContainer.removeEssence(stack, FUEL_ESSENCE_TYPE, this.useCost);
            return true;
        }
        return false;
    }

    public InteractionResult useOn(UseOnContext context) {
        Direction direction;
        Level world = context.getLevel();
        if (world.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.getClickedPos();
        BlockPos target = pos.offset((direction = context.getClickedFace()).getNormal());
        if (this.placeLight(world, target, context.getItemInHand())) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        if (ItemEssenceContainer.getEssence(stack, FUEL_ESSENCE_TYPE) >= this.useCost) {
            interactionTarget.addEffect(new MobEffectInstance(MobEffects.GLOWING, 60));
            ItemEssenceContainer.removeEssence(stack, FUEL_ESSENCE_TYPE, this.useCost);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }
}

