/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.item.equipment;

import com.cmdpro.datanessence.registry.SoundRegistry;
import com.cmdpro.datanessence.registry.TagRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class HammerAndChisel
extends Item {
    public HammerAndChisel(Item.Properties properties) {
        super(properties);
    }

    public boolean chiselBlock(Level world, BlockPos target, ItemStack stack, Player player) {
        BlockState targetState = world.getBlockState(target);
        if (targetState.is(TagRegistry.Blocks.HAMMER_AND_CHISEL_COLLECTABLE)) {
            stack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(stack));
            return true;
        }
        return false;
    }

    public boolean hammerBlock(Level world, BlockPos target, ItemStack stack, Player player) {
        BlockState targetState = world.getBlockState(target);
        if (targetState.is(TagRegistry.Blocks.HAMMER_AND_CHISEL_COLLECTABLE)) {
            stack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(stack));
            world.destroyBlock(target, true);
            return true;
        }
        return false;
    }

    public void playSound(Level world, BlockPos target) {
        world.playSound(null, target, (SoundEvent)SoundRegistry.HAMMER_AND_CHISEL_MINE.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (world.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if (this.hammerBlock(world, pos, context.getItemInHand(), player)) {
            this.playSound(world, pos);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }
}

