/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.item.equipment;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.item.ItemEssenceContainer;
import com.cmdpro.datanessence.entity.EssenceSlashProjectile;
import com.cmdpro.datanessence.registry.DataComponentRegistry;
import com.cmdpro.datanessence.registry.EntityRegistry;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.SimpleTier;
import net.neoforged.neoforge.common.Tags;

public class EssenceSword
extends SwordItem {
    public static final Tier ESSENCE_SWORD = new SimpleTier(BlockTags.INCORRECT_FOR_IRON_TOOL, 750, 6.0f, 2.0f, 14, () -> Ingredient.of((TagKey)Tags.Items.INGOTS_COPPER));
    public static ResourceLocation FUEL_ESSENCE_TYPE = DataNEssence.locate("essence");

    public EssenceSword(Item.Properties pProperties) {
        super(ESSENCE_SWORD, pProperties.attributes(SwordItem.createAttributes((Tier)ESSENCE_SWORD, (int)3, (float)-2.4f)).component(DataComponentRegistry.ESSENCE_STORAGE, (Object)new ItemEssenceContainer(List.of(FUEL_ESSENCE_TYPE), 10000.0f)));
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.getItemInHand(pUsedHand);
        if (!pLevel.isClientSide && ItemEssenceContainer.getEssence(stack, FUEL_ESSENCE_TYPE) >= 10.0f) {
            ItemEssenceContainer.removeEssence(stack, FUEL_ESSENCE_TYPE, 10.0f);
            EssenceSlashProjectile slash = new EssenceSlashProjectile(EntityRegistry.ESSENCE_SLASH_PROJECTILE.get(), (LivingEntity)pPlayer, pLevel);
            slash.setPos(slash.position().offsetRandom(pPlayer.getRandom(), 0.25f));
            pLevel.addFreshEntity((Entity)slash);
            pPlayer.getCooldowns().addCooldown((Item)this, 20);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)pLevel.isClientSide);
    }
}

