/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.item;

import com.cmdpro.datanessence.registry.DataComponentRegistry;
import com.cmdpro.datanessence.screen.MusicDiscPlayerMenu;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class MusicDiscPlayer
extends Item {
    public MusicDiscPlayer(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, final Player pPlayer, final InteractionHand pUsedHand) {
        if (!pLevel.isClientSide) {
            pPlayer.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.empty();
                }

                @Nullable
                public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer2) {
                    return new MusicDiscPlayerMenu(pContainerId, pPlayerInventory, pPlayer.getItemInHand(pUsedHand));
                }
            }, buf -> buf.writeInt(pPlayer.getInventory().findSlotMatchingItem(pPlayer.getItemInHand(pUsedHand))));
        }
        return InteractionResultHolder.sidedSuccess((Object)pPlayer.getItemInHand(pUsedHand), (boolean)pLevel.isClientSide);
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        JukeboxSong song;
        JukeboxPlayable playable;
        super.inventoryTick(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        boolean remove = true;
        ItemContainerContents handler = (ItemContainerContents)pStack.get(DataComponents.CONTAINER);
        if (handler != null && handler.getSlots() > 0 && (playable = (JukeboxPlayable)handler.getStackInSlot(0).get(DataComponents.JUKEBOX_PLAYABLE)) != null && (song = (JukeboxSong)((Registry)pLevel.registryAccess().registry(Registries.JUKEBOX_SONG).get()).get(playable.song().key())) != null) {
            pStack.set(DataComponentRegistry.PLAYING_MUSIC, (Object)song.soundEvent().getKey());
            remove = false;
        }
        if (remove) {
            pStack.remove(DataComponentRegistry.PLAYING_MUSIC);
        }
    }
}

