/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.item;

import com.cmdpro.datanessence.data.pinging.PingableStructure;
import com.cmdpro.datanessence.data.pinging.PingableStructureManager;
import com.cmdpro.datanessence.data.pinging.StructurePing;
import com.cmdpro.datanessence.networking.ModMessages;
import com.cmdpro.datanessence.networking.packet.s2c.CreatePingShader;
import com.cmdpro.datanessence.networking.packet.s2c.PingStructures;
import com.cmdpro.datanessence.registry.SoundRegistry;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class Locator
extends Item {
    public Locator(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (!pLevel.isClientSide) {
            pLevel.playSound(null, pPlayer.blockPosition(), (SoundEvent)SoundRegistry.LOCATOR_PING.value(), SoundSource.PLAYERS);
            ArrayList<StructurePing> pings = new ArrayList<StructurePing>();
            ServerLevel serverLevel = (ServerLevel)pLevel;
            for (Map.Entry<ResourceLocation, PingableStructure> i : PingableStructureManager.types.entrySet()) {
                Pair result;
                Optional structure;
                Optional registry;
                if (pPlayer instanceof ServerPlayer) {
                    AdvancementHolder advancement;
                    ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                    if (i.getValue().requiredAdvancement.isPresent() && (advancement = serverLevel.getServer().getAdvancements().get(i.getValue().requiredAdvancement.get().location())) != null && !serverPlayer.getAdvancements().getOrStartProgress(advancement).isDone()) continue;
                }
                if (!(registry = serverLevel.registryAccess().registry(Registries.STRUCTURE)).isPresent() || !(structure = ((Registry)registry.get()).getHolder(i.getValue().structure)).isPresent() || (result = serverLevel.getChunkSource().getGenerator().findNearestMapStructure(serverLevel, (HolderSet)HolderSet.direct((Holder[])new Holder[]{(Holder)structure.get()}), pPlayer.blockPosition(), 50, false)) == null) continue;
                boolean known = false;
                if (pPlayer instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                    AdvancementHolder advancement = serverLevel.getServer().getAdvancements().get(i.getValue().advancement.location());
                    if (advancement != null) {
                        known = serverPlayer.getAdvancements().getOrStartProgress(advancement).isDone();
                    }
                }
                pings.add(new StructurePing((BlockPos)result.getFirst(), i.getKey(), known));
            }
            ModMessages.sendToPlayer(new PingStructures(pings), (ServerPlayer)pPlayer);
            ModMessages.sendToPlayersNear(new CreatePingShader(pPlayer.position()), serverLevel, pPlayer.position(), 128.0f);
            pPlayer.getCooldowns().addCooldown((Item)this, 200);
        }
        return InteractionResultHolder.sidedSuccess((Object)pPlayer.getItemInHand(pUsedHand), (boolean)pLevel.isClientSide);
    }
}

