/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.item;

import com.cmdpro.datanessence.api.util.DataTabletUtil;
import com.cmdpro.datanessence.block.auxiliary.DataBankBlockEntity;
import com.cmdpro.datanessence.data.datatablet.Entries;
import com.cmdpro.datanessence.data.datatablet.Entry;
import com.cmdpro.datanessence.registry.AttachmentTypeRegistry;
import com.cmdpro.datanessence.registry.ItemRegistry;
import com.cmdpro.datanessence.screen.DataTabletScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DataTablet
extends Item {
    public DataTablet(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.getItemInHand(pUsedHand);
        if (pLevel.isClientSide) {
            Client.openScreen();
        } else {
            if (DataTabletUtil.getTier(pPlayer) <= 0) {
                DataTabletUtil.setTier(pPlayer, 1);
            }
            this.unlockStartingEntries(pPlayer);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)pLevel.isClientSide);
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (player != null && stack.is(ItemRegistry.DATA_TABLET.get()) && player.isShiftKeyDown()) {
            BlockEntity blockEntity;
            if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof DataBankBlockEntity) {
                DataBankBlockEntity ent = (DataBankBlockEntity)blockEntity;
                List<ResourceLocation> entries = ((ArrayList)player.getData(AttachmentTypeRegistry.UNLOCKED.get())).stream().filter(i -> !ent.data.contains(i)).toList();
                player.sendSystemMessage((Component)Component.translatable((String)"block.datanessence.player_data_bank.bind", (Object[])new Object[]{entries.size()}));
                ent.data.addAll(entries);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useOn(context);
    }

    public void unlockStartingEntries(Player player) {
        for (Entry i : Entries.entries.values().stream().filter(entry -> entry.isDefault).toList()) {
            DataTabletUtil.unlockEntryAndParents(player, i.id, 0);
        }
    }

    public static class Client {
        public static void openScreen() {
            Minecraft.getInstance().setScreen((Screen)new DataTabletScreen((Component)Component.empty()));
        }
    }
}

