/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.item;

import com.cmdpro.datanessence.data.datatablet.Entries;
import com.cmdpro.datanessence.data.datatablet.Entry;
import com.cmdpro.datanessence.registry.DataComponentRegistry;
import com.cmdpro.datanessence.screen.DataDriveScreen;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class DataDrive
extends Item {
    public DataDrive(Item.Properties pProperties) {
        super(pProperties);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        if (pStack.has(DataComponentRegistry.DATA_ID)) {
            Entry entry = Entries.entries.get(pStack.get(DataComponentRegistry.DATA_ID));
            int stage = (Integer)pStack.getOrDefault(DataComponentRegistry.DATA_INCOMPLETE, (Object)entry.completionStages.size());
            pTooltipComponents.add((Component)Component.translatable((String)"item.datanessence.data_drive.loaded", (Object[])new Object[]{entry.getName(stage)}).withStyle(ChatFormatting.GRAY));
            if (pStack.has(DataComponentRegistry.DATA_INCOMPLETE) && stage < entry.completionStages.size()) {
                pTooltipComponents.add((Component)Component.translatable((String)"item.datanessence.data_drive.incomplete", (Object[])new Object[]{stage, entry.completionStages.size()}).withStyle(ChatFormatting.GRAY));
            }
        } else {
            pTooltipComponents.add((Component)Component.translatable((String)"item.datanessence.data_drive.empty").withStyle(ChatFormatting.GRAY));
        }
    }

    public static Entry getEntry(ItemStack stack) {
        if (stack != null && stack.has(DataComponentRegistry.DATA_ID)) {
            return Entries.entries.get(stack.get(DataComponentRegistry.DATA_ID));
        }
        return null;
    }

    public static ResourceLocation getEntryId(ItemStack stack) {
        if (stack != null && stack.has(DataComponentRegistry.DATA_ID)) {
            return Entries.entries.get((Object)stack.get(DataComponentRegistry.DATA_ID)).id;
        }
        return null;
    }

    public static Integer getEntryCompletionStage(ItemStack stack) {
        if (stack != null && stack.has(DataComponentRegistry.DATA_ID)) {
            return (Integer)stack.get(DataComponentRegistry.DATA_INCOMPLETE);
        }
        return null;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pLevel.isClientSide) {
            Client.openScreen(pUsedHand == InteractionHand.OFF_HAND);
        }
        return InteractionResultHolder.sidedSuccess((Object)pPlayer.getItemInHand(pUsedHand), (boolean)pLevel.isClientSide);
    }

    public static class Client {
        public static void openScreen(boolean offhand) {
            Minecraft.getInstance().setScreen((Screen)new DataDriveScreen((Component)Component.empty(), offhand));
        }
    }
}

