/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.item;

import com.cmdpro.datanessence.api.CommonVariables;
import com.cmdpro.datanessence.registry.SoundRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.apache.commons.lang3.RandomUtils;
import org.joml.Math;

public class CognizantCube
extends Item {
    final int textColor = 10233543;
    public List<Component> results = new ArrayList<Component>(){
        {
            this.add(Component.translatable((String)"item.datanessence.magitech_8_ball.result1").withStyle(Style.EMPTY.withColor(10233543)));
            this.add(Component.translatable((String)"item.datanessence.magitech_8_ball.result2").withStyle(Style.EMPTY.withColor(10233543)));
            this.add(Component.translatable((String)"item.datanessence.magitech_8_ball.result3").withStyle(Style.EMPTY.withColor(10233543)));
            this.add(Component.translatable((String)"item.datanessence.magitech_8_ball.result4").withStyle(Style.EMPTY.withColor(10233543)));
            this.add(Component.translatable((String)"item.datanessence.magitech_8_ball.result5").withStyle(Style.EMPTY.withColor(10233543)));
            this.add(Component.translatable((String)"item.datanessence.magitech_8_ball.result6").withStyle(Style.EMPTY.withColor(10233543)));
            this.add(Component.translatable((String)"item.datanessence.magitech_8_ball.result7").withStyle(Style.EMPTY.withColor(10233543)));
            this.add(Component.translatable((String)"item.datanessence.magitech_8_ball.result8").withStyle(Style.EMPTY.withColor(10233543)));
            this.add(Component.translatable((String)"item.datanessence.magitech_8_ball.result9").withStyle(Style.EMPTY.withColor(10233543)));
            this.add(Component.translatable((String)"item.datanessence.magitech_8_ball.result10").withStyle(Style.EMPTY.withColor(10233543)));
        }
    };
    public Component additionalPylons = Component.translatable((String)"item.datanessence.magitech_8_ball.result11").withStyle(Style.EMPTY.withFont(CommonVariables.ANCIENT_FONT).withColor(10233543));

    public CognizantCube(Item.Properties pProperties) {
        super(pProperties);
    }

    public int getUseDuration(ItemStack pStack, LivingEntity p_344979_) {
        return 38;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(this){

            public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
                if (player.getUseItem() == itemInHand && player.isUsingItem()) {
                    float f = (float)itemInHand.getUseDuration((LivingEntity)player) - (float)player.getUseItemRemainingTicks() + partialTick;
                    poseStack.mulPose(Axis.XP.rotationDegrees(Math.sin((float)Math.toRadians((float)(Math.clamp((float)0.0f, (float)36.0f, (float)f) * 30.0f))) * 25.0f));
                    this.applyItemArmTransform(poseStack, arm, equipProcess);
                    return true;
                }
                return false;
            }

            private void applyItemArmTransform(PoseStack pPoseStack, HumanoidArm pHand, float pEquippedProg) {
                int i = pHand == HumanoidArm.RIGHT ? 1 : -1;
                pPoseStack.translate((float)i * 0.56f, -0.52f + pEquippedProg * -0.6f, -0.72f);
            }
        });
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.CUSTOM;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        pPlayer.startUsingItem(pHand);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public void onUseTick(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        super.onUseTick(pLevel, pLivingEntity, pStack, pRemainingUseDuration);
        if (!pLevel.isClientSide && pRemainingUseDuration % 6 == 0) {
            pLevel.playSound(null, pLivingEntity.blockPosition(), (SoundEvent)SoundRegistry.COGNIZANT_CUBE_SHAKE.value(), SoundSource.PLAYERS);
        }
    }

    public ItemStack finishUsingItem(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        if (!pLevel.isClientSide) {
            pLevel.playSound(null, pLivingEntity.blockPosition(), (SoundEvent)SoundRegistry.COGNIZANT_CUBE_MESSAGE.value(), SoundSource.PLAYERS);
            if (pLivingEntity instanceof Player) {
                Player player = (Player)pLivingEntity;
                Component msg = this.results.get(RandomUtils.nextInt((int)0, (int)this.results.size()));
                if (RandomUtils.nextInt((int)0, (int)25) == 0) {
                    msg = this.additionalPylons;
                }
                player.sendSystemMessage(msg);
                player.getCooldowns().addCooldown((Item)this, 20);
            }
        }
        return pStack;
    }
}

