/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.integration.mekanism;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.node.block.BaseCapabilityPointBlockEntity;
import com.cmdpro.datanessence.config.DataNEssenceConfig;
import com.cmdpro.datanessence.integration.DataNEssenceIntegration;
import com.cmdpro.datanessence.integration.mekanism.ICustomChemicalNodeBehaviour;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import java.awt.Color;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jgrapht.GraphPath;
import org.jgrapht.graph.DefaultEdge;
import org.joml.Math;

public class ChemicalNodeBlockEntity
extends BaseCapabilityPointBlockEntity {
    public ChemicalNodeBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(BlockEntityRegistry.CHEMICAL_NODE.get(), pPos, pBlockState);
    }

    @Override
    public Color linkColor() {
        return new Color(6679052);
    }

    @Override
    public void transfer(BaseCapabilityPointBlockEntity from, List<GraphPath<BlockPos, DefaultEdge>> other) {
        int transferAmount = (int)Math.floor((float)((float)this.getFinalSpeed(DataNEssenceConfig.fluidPointTransfer) / (float)other.size()));
        for (GraphPath<BlockPos, DefaultEdge> i : other) {
            ICustomChemicalNodeBehaviour behaviour;
            BlockEntity blockEntity = this.level.getBlockEntity((BlockPos)i.getEndVertex());
            if (!(blockEntity instanceof BaseCapabilityPointBlockEntity)) continue;
            BaseCapabilityPointBlockEntity to = (BaseCapabilityPointBlockEntity)blockEntity;
            List<ChemicalStack> allowedChemicals = null;
            for (BlockPos j : i.getVertexList()) {
                BlockEntity blockEntity2 = this.level.getBlockEntity(j);
                if (!(blockEntity2 instanceof BaseCapabilityPointBlockEntity)) continue;
                BaseCapabilityPointBlockEntity to2 = (BaseCapabilityPointBlockEntity)blockEntity2;
                List<ChemicalStack> value = to2.getValue(DataNEssence.locate("allowed_chemicals"), null);
                if (allowedChemicals == null) {
                    allowedChemicals = value;
                    continue;
                }
                if (value == null) continue;
                allowedChemicals = allowedChemicals.stream().filter(stack1 -> value.stream().anyMatch(stack2 -> ChemicalStack.isSameChemical((ChemicalStack)stack1, (ChemicalStack)stack2))).toList();
            }
            IChemicalHandler resolved = (IChemicalHandler)this.level.getCapability(DataNEssenceIntegration.BLOCK_CHEMICAL, to.getBlockPos().relative(to.getDirection().getOpposite()), (Object)to.getDirection());
            IChemicalHandler resolved2 = (IChemicalHandler)this.level.getCapability(DataNEssenceIntegration.BLOCK_CHEMICAL, from.getBlockPos().relative(from.getDirection().getOpposite()), (Object)from.getDirection());
            if (resolved == null || resolved2 == null || other instanceof ICustomChemicalNodeBehaviour && !(behaviour = (ICustomChemicalNodeBehaviour)((Object)other)).canInsertChemical(resolved, resolved2)) continue;
            for (int o = 0; o < resolved2.getChemicalTanks(); ++o) {
                ChemicalStack copy = resolved2.getChemicalInTank(o).copy();
                if (allowedChemicals != null && allowedChemicals.stream().noneMatch(stack -> ChemicalStack.isSameChemical((ChemicalStack)stack, (ChemicalStack)copy)) || copy.isEmpty()) continue;
                copy.setAmount((long)Math.clamp((float)0.0f, (float)transferAmount, (float)copy.getAmount()));
                ChemicalStack filled = resolved.insertChemical(copy, Action.EXECUTE);
                resolved2.extractChemical(new ChemicalStack(copy.getChemical(), filled.getAmount()), Action.EXECUTE);
            }
        }
    }
}

