/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.integration.emi.widgets;

import com.cmdpro.datanessence.api.DataNEssenceRegistries;
import com.cmdpro.datanessence.api.essence.EssenceBarBackgroundType;
import com.cmdpro.datanessence.api.essence.EssenceType;
import com.cmdpro.datanessence.api.util.client.ClientEssenceBarUtil;
import com.cmdpro.datanessence.moddata.ClientPlayerData;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

public class EssenceBarWidget
extends Widget {
    public EssenceType type;
    public int x;
    public int y;
    public float cost;
    public float max;
    public EssenceBarBackgroundType backgroundType;

    public EssenceBarWidget(int x, int y, EssenceType type, float cost, float max, EssenceBarBackgroundType backgroundType) {
        this.type = type;
        this.cost = cost;
        this.x = x;
        this.y = y;
        this.max = max;
        this.backgroundType = backgroundType;
    }

    public Bounds getBounds() {
        return new Bounds(this.x, this.y, 3, 22);
    }

    public void render(GuiGraphics draw, int mouseX, int mouseY, float delta) {
        ClientEssenceBarUtil.drawEssenceBarTiny(draw, this.x, this.y, this.type, this.cost, this.max, this.backgroundType);
    }

    public List<ClientTooltipComponent> getTooltip(int mouseX, int mouseY) {
        if (this.cost > 0.0f && this.getBounds().contains(mouseX, mouseY)) {
            if (ClientPlayerData.getUnlockedEssences().getOrDefault(DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.getKey((Object)this.type), false).booleanValue()) {
                return List.of(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)this.type.getTooltipKey(), (Object[])new Object[]{Float.valueOf(this.cost)}).getVisualOrderText()));
            }
            return List.of(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)"gui.essence_bar.unknown", (Object[])new Object[]{Float.valueOf(this.cost)}).getVisualOrderText()));
        }
        return super.getTooltip(mouseX, mouseY);
    }
}

