/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.integration.emi.recipes;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.DataNEssenceRegistries;
import com.cmdpro.datanessence.api.essence.EssenceBarBackgroundTypes;
import com.cmdpro.datanessence.api.essence.EssenceType;
import com.cmdpro.datanessence.integration.emi.DataNEssenceEMIPlugin;
import com.cmdpro.datanessence.integration.emi.DataNEssenceEMIRecipe;
import com.cmdpro.datanessence.integration.emi.widgets.EssenceBarWidget;
import com.cmdpro.datanessence.recipe.IFabricationRecipe;
import com.cmdpro.datanessence.recipe.ShapedFabricationRecipe;
import com.cmdpro.datanessence.recipe.ShapelessFabricationRecipe;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.screen.DataTabletScreen;
import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class EMIFabricationRecipe
extends DataNEssenceEMIRecipe {
    private final boolean shapeless;
    private final Map<EssenceType, Float> essenceCost;
    private final int width;
    private final int height;

    public EMIFabricationRecipe(ResourceLocation id, IFabricationRecipe recipe) {
        super(DataNEssenceEMIPlugin.FABRICATION, id, recipe.getEntry(), 123, 60);
        this.shapeless = recipe instanceof ShapelessFabricationRecipe;
        this.inputs = EMIFabricationRecipe.getIngredients(recipe, this.shapeless);
        this.outputs = List.of(EmiStack.of((ItemStack)recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())));
        this.essenceCost = new HashMap<EssenceType, Float>();
        for (Map.Entry i : recipe.getEssenceCost().entrySet()) {
            this.essenceCost.put((EssenceType)DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.get((ResourceLocation)i.getKey()), (Float)i.getValue());
        }
        if (recipe instanceof ShapedFabricationRecipe) {
            ShapedFabricationRecipe recipe1 = (ShapedFabricationRecipe)recipe;
            this.width = recipe1.getWidth();
            this.height = recipe1.getHeight();
        } else {
            this.width = 3;
            this.height = 3;
        }
    }

    private static List<EmiIngredient> getIngredients(IFabricationRecipe recipe, boolean isShapeless) {
        ArrayList input;
        if (isShapeless) {
            input = recipe.getIngredients().stream().map(EmiIngredient::of).toList();
        } else {
            int width = recipe.canCraftInDimensions(2, 3) ? (recipe.canCraftInDimensions(1, 3) ? 1 : 2) : 3;
            input = Lists.newArrayList();
            for (int i = 0; i < recipe.getIngredients().size(); ++i) {
                input.add(EmiIngredient.of((Ingredient)((Ingredient)recipe.getIngredients().get(i))));
                if ((i + 1) % width != 0) continue;
                for (int j = width; j < 3; ++j) {
                    input.add(EmiStack.EMPTY);
                }
            }
        }
        return input;
    }

    public int getDisplayWidth() {
        return 123;
    }

    public int getDisplayHeight() {
        return 60;
    }

    public boolean canFit(int width, int height) {
        if (this.inputs.size() > 9) {
            return false;
        }
        for (int i = 0; i < this.inputs.size(); ++i) {
            int x = i % 3;
            int y = i / 3;
            if (((EmiIngredient)this.inputs.get(i)).isEmpty() || x < width && y < height) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addUnlockedWidgets(WidgetHolder widgetHolder) {
        ResourceLocation background = DataNEssence.locate("textures/gui/data_tablet_crafting.png");
        widgetHolder.addTexture(background, 0, 0, this.getDisplayWidth(), this.getDisplayHeight(), 10, 196);
        widgetHolder.addSlot((EmiIngredient)this.outputs.get(0), 97, 21).recipeContext((EmiRecipe)this).drawBack(false);
        int sOff = 0;
        if (!this.shapeless) {
            if (this.canFit(1, 3)) {
                --sOff;
            }
            if (this.canFit(3, 1)) {
                sOff -= 3;
            }
        } else {
            widgetHolder.addTexture(DataTabletScreen.TEXTURE_CRAFTING, 93, 4, 14, 11, 242, 185);
        }
        for (int i = 0; i < 9; ++i) {
            int s = i + sOff;
            if (s >= 0 && s < this.inputs.size()) {
                widgetHolder.addSlot((EmiIngredient)this.inputs.get(s), i % 3 * 17 + 20, i / 3 * 17 + 4).drawBack(false);
                continue;
            }
            widgetHolder.addSlot((EmiIngredient)EmiStack.of((ItemStack)ItemStack.EMPTY), i % 3 * 17 + 20, i / 3 * 17 + 4).drawBack(false);
        }
        widgetHolder.add((Widget)new EssenceBarWidget(5, 6, EssenceTypeRegistry.ESSENCE.get(), this.essenceCost.getOrDefault(EssenceTypeRegistry.ESSENCE.get(), Float.valueOf(0.0f)).floatValue(), 1000.0f, EssenceBarBackgroundTypes.INDUSTRIAL));
        widgetHolder.add((Widget)new EssenceBarWidget(13, 6, EssenceTypeRegistry.LUNAR_ESSENCE.get(), this.essenceCost.getOrDefault(EssenceTypeRegistry.LUNAR_ESSENCE.get(), Float.valueOf(0.0f)).floatValue(), 1000.0f, EssenceBarBackgroundTypes.INDUSTRIAL));
        widgetHolder.add((Widget)new EssenceBarWidget(5, 32, EssenceTypeRegistry.NATURAL_ESSENCE.get(), this.essenceCost.getOrDefault(EssenceTypeRegistry.NATURAL_ESSENCE.get(), Float.valueOf(0.0f)).floatValue(), 1000.0f, EssenceBarBackgroundTypes.INDUSTRIAL));
        widgetHolder.add((Widget)new EssenceBarWidget(13, 32, EssenceTypeRegistry.EXOTIC_ESSENCE.get(), this.essenceCost.getOrDefault(EssenceTypeRegistry.EXOTIC_ESSENCE.get(), Float.valueOf(0.0f)).floatValue(), 1000.0f, EssenceBarBackgroundTypes.INDUSTRIAL));
    }
}

