/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.integration.emi;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.moddata.ClientPlayerUnlockedEntries;
import com.cmdpro.datanessence.recipe.IHasRequiredKnowledge;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class DataNEssenceEMIRecipe
implements EmiRecipe {
    public static final Component lockedText1 = Component.translatable((String)"emi.datanessence.recipe_locked_line_1");
    public static final Component lockedText2 = Component.translatable((String)"emi.datanessence.recipe_locked_line_2");
    public final EmiRecipeCategory category;
    public final ResourceLocation recipe;
    public final ResourceLocation recipeUnlockEntry;
    public final int width;
    public final int height;
    public List<EmiIngredient> inputs = List.of();
    public List<EmiStack> outputs = List.of();

    public DataNEssenceEMIRecipe(EmiRecipeCategory category, ResourceLocation recipe, ResourceLocation recipeUnlockEntry, int width, int height) {
        this.category = category;
        this.recipe = recipe;
        this.recipeUnlockEntry = recipeUnlockEntry;
        this.width = width;
        this.height = height;
    }

    public boolean isUnlocked() {
        return this.recipeUnlockEntry == null || this.hasData(this.recipeUnlockEntry, this.recipe);
    }

    public boolean hasData(ResourceLocation dataEntry, ResourceLocation recipe) {
        IHasRequiredKnowledge dataLockedRecipe = (IHasRequiredKnowledge)this.getBackingRecipe().value();
        return ClientPlayerUnlockedEntries.getUnlocked().contains(dataEntry) || ClientPlayerUnlockedEntries.getIncomplete().containsKey(dataEntry) && ClientPlayerUnlockedEntries.getIncomplete().get(dataEntry) >= dataLockedRecipe.getCompletionStage();
    }

    public abstract void addUnlockedWidgets(WidgetHolder var1);

    public void addWidgets(WidgetHolder widgets) {
        if (!this.isUnlocked()) {
            ResourceLocation background = DataNEssence.locate("textures/gui/emi_recipe_locked.png");
            int lightColor = -26955;
            int darkColor = -893279;
            widgets.addTexture(background, 0, 0, 123, 60, 0, 0);
            widgets.addText(lockedText1, 119, 30, lightColor, false).horizontalAlign(TextWidget.Alignment.END);
            widgets.addText(lockedText2, 119, 40, darkColor, false).horizontalAlign(TextWidget.Alignment.END);
        } else {
            this.addUnlockedWidgets(widgets);
        }
    }

    public EmiRecipeCategory getCategory() {
        return this.category;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.recipe;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public boolean supportsRecipeTree() {
        return super.supportsRecipeTree() && this.isUnlocked();
    }
}

