/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.entity;

import com.cmdpro.databank.misc.ColorGradient;
import com.cmdpro.datanessence.entity.ThrownTrailItemProjectile;
import com.cmdpro.datanessence.misc.NaturalEssenceBombExplosion;
import com.cmdpro.datanessence.registry.EntityRegistry;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.registry.ItemRegistry;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class ThrownNaturalEssenceBombProjectile
extends ThrownTrailItemProjectile {
    public ThrownNaturalEssenceBombProjectile(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ThrownNaturalEssenceBombProjectile(LivingEntity pShooter, Level pLevel) {
        super(EntityRegistry.NATURAL_ESSENCE_BOMB.get(), pShooter, pLevel);
    }

    public ThrownNaturalEssenceBombProjectile(Level pLevel, double pX, double pY, double pZ) {
        super(EntityRegistry.NATURAL_ESSENCE_BOMB.get(), pX, pY, pZ, pLevel);
    }

    protected Item getDefaultItem() {
        return ItemRegistry.NATURAL_ESSENCE_BOMB.get();
    }

    protected void onHit(HitResult pResult) {
        super.onHit(pResult);
        if (!this.level().isClientSide) {
            Explosion.BlockInteraction explosion$blockinteraction1;
            Explosion.BlockInteraction explosion$blockinteraction = explosion$blockinteraction1 = this.level().getGameRules().getBoolean(GameRules.RULE_BLOCK_EXPLOSION_DROP_DECAY) ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.DESTROY;
            NaturalEssenceBombExplosion explosion = new NaturalEssenceBombExplosion(this.level(), (Entity)this, null, null, pResult.getLocation().x, pResult.getLocation().y, pResult.getLocation().z, 5.0f, false, explosion$blockinteraction);
            if (EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion)) {
                return;
            }
            explosion.explode();
            explosion.finalizeExplosion(true);
            for (ServerPlayer serverplayer : ((ServerLevel)this.level()).players()) {
                if (!(serverplayer.distanceToSqr(pResult.getLocation().x, pResult.getLocation().y, pResult.getLocation().z) < 4096.0)) continue;
                serverplayer.connection.send((Packet)new ClientboundExplodePacket(pResult.getLocation().x, pResult.getLocation().y, pResult.getLocation().z, 5.0f, explosion.getToBlow(), (Vec3)explosion.getHitPlayers().get(serverplayer), explosion.getBlockInteraction(), explosion.getSmallExplosionParticles(), explosion.getLargeExplosionParticles(), explosion.getExplosionSound()));
            }
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    public ColorGradient getGradient() {
        return EssenceTypeRegistry.NATURAL_ESSENCE.get().getThrowGradient();
    }
}

