/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.entity;

import com.cmdpro.datanessence.registry.DamageTypeRegistry;
import com.cmdpro.datanessence.registry.EntityRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import org.joml.Math;

public class BlackHole
extends Entity {
    public static final EntityDataAccessor<Float> SIZE = SynchedEntityData.defineId(BlackHole.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> MAX_SIZE = SynchedEntityData.defineId(BlackHole.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public int lifetime;
    public float size;

    public BlackHole(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(SIZE, (Object)Float.valueOf(0.0f));
        pBuilder.define(MAX_SIZE, (Object)Float.valueOf(0.0f));
    }

    protected void readAdditionalSaveData(CompoundTag pCompound) {
        this.size = pCompound.getFloat("size");
        this.lifetime = pCompound.getInt("lifetime");
    }

    protected void addAdditionalSaveData(CompoundTag pCompound) {
        pCompound.putFloat("size", this.size);
        pCompound.putInt("lifetime", this.lifetime);
    }

    public void tick() {
        super.tick();
        ++this.lifetime;
        if (this.level().isClientSide) {
            if (this.lifetime <= 10) {
                this.entityData.set(SIZE, (Object)Float.valueOf(((Float)this.entityData.get(MAX_SIZE)).floatValue() * ((float)this.lifetime / 10.0f)));
            } else {
                this.entityData.set(SIZE, (Object)Float.valueOf(((Float)this.entityData.get(SIZE)).floatValue() - 0.05f));
            }
        } else {
            for (Entity i : this.level().getEntitiesOfClass(Entity.class, AABB.ofSize((Vec3)this.getBoundingBox().getCenter(), (double)(((Float)this.entityData.get(SIZE)).floatValue() * 2.5f), (double)(((Float)this.entityData.get(SIZE)).floatValue() * 2.5f), (double)(((Float)this.entityData.get(SIZE)).floatValue() * 2.5f)))) {
                if (i == this || i.getType().is(Tags.EntityTypes.BOSSES) || i.getType().equals(EntityRegistry.BLACK_HOLE.get())) continue;
                if (i instanceof Player) {
                    i.hurtMarked = true;
                }
                float mult = Math.clamp((float)0.0f, (float)0.5f, (float)(((Float)this.entityData.get(SIZE)).floatValue() * 2.5f - i.distanceTo((Entity)this)));
                Vec3 add = this.getBoundingBox().getCenter().subtract(i.position()).normalize().multiply((double)mult, (double)mult, (double)mult);
                if (!(add.length() >= 0.1)) continue;
                if (this.getBoundingBox().getCenter().distanceTo(i.position()) <= (double)(((Float)this.entityData.get(SIZE)).floatValue() / 4.0f)) {
                    i.setDeltaMovement(add);
                    continue;
                }
                Vec3 movement = i.getDeltaMovement().add(add);
                i.setDeltaMovement(movement);
            }
            for (Entity i : this.level().getEntitiesOfClass(Entity.class, AABB.ofSize((Vec3)this.getBoundingBox().getCenter(), (double)((Float)this.entityData.get(SIZE)).floatValue(), (double)((Float)this.entityData.get(SIZE)).floatValue(), (double)((Float)this.entityData.get(SIZE)).floatValue()))) {
                i.hurt(this.damageSources().source(DamageTypeRegistry.blackHole), 10.0f);
            }
            this.entityData.set(MAX_SIZE, (Object)Float.valueOf(this.size));
            if (this.lifetime > 10) {
                this.size -= 0.05f;
                if (this.size <= 0.0f) {
                    this.remove(Entity.RemovalReason.KILLED);
                }
                this.entityData.set(SIZE, (Object)Float.valueOf(this.size));
            }
        }
    }
}

