/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.entity;

import com.cmdpro.datanessence.client.particle.CircleParticleOptions;
import com.cmdpro.datanessence.registry.DamageTypeRegistry;
import com.cmdpro.datanessence.registry.SoundRegistry;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class AncientSentinelProjectile
extends Projectile {
    public int time;
    Vec3 previousPos;
    public int blockInvincibility;
    boolean hasAimed = false;

    public AncientSentinelProjectile(EntityType<AncientSentinelProjectile> entityType, Level world) {
        super(entityType, world);
    }

    protected AncientSentinelProjectile(EntityType<AncientSentinelProjectile> entityType, double x, double y, double z, Level world) {
        this(entityType, world);
        this.setPos(x, y, z);
    }

    public AncientSentinelProjectile(EntityType<AncientSentinelProjectile> entityType, LivingEntity shooter, Level world) {
        this(entityType, shooter.getX(), shooter.getEyeY() - (double)0.1f, shooter.getZ(), world);
        this.setOwner((Entity)shooter);
        this.setDeltaMovement(shooter.getLookAngle().multiply(0.5, 0.5, 0.5));
    }

    protected void onHitBlock(BlockHitResult hit) {
        float pitch = Mth.nextFloat((RandomSource)this.getRandom(), (float)0.9f, (float)1.1f);
        if (!this.hasAimed) {
            this.reAim();
        } else if (this.blockInvincibility <= 0) {
            pitch *= 0.75f;
            this.remove(Entity.RemovalReason.KILLED);
        }
        this.level().playSound(null, this.blockPosition(), (SoundEvent)SoundRegistry.ANCIENT_SENTINEL_PROJECTILE_HIT_BLOCK.value(), SoundSource.HOSTILE, 1.0f, pitch);
        super.onHitBlock(hit);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("time", this.time);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.time = tag.getInt("time");
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 p_36758_, Vec3 p_36759_) {
        return ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)p_36758_, (Vec3)p_36759_, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), x$0 -> this.canHitEntity((Entity)x$0));
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
    }

    public void reAim() {
        Entity entity = this.getOwner();
        if (entity != null) {
            double speed = this.getDeltaMovement().length() / 2.0;
            this.setDeltaMovement(entity.getEyePosition().subtract(this.getBoundingBox().getCenter()).normalize().scale(speed));
            this.hasImpulse = true;
            this.hasAimed = true;
            this.blockInvincibility = 2;
        }
    }

    public void tick() {
        this.previousPos = this.position();
        this.setPos(this.getX() + this.getDeltaMovement().x, this.getY() + this.getDeltaMovement().y, this.getZ() + this.getDeltaMovement().z);
        if (!this.level().isClientSide) {
            HitResult hitresult;
            if (this.blockInvincibility > 0) {
                --this.blockInvincibility;
            }
            ++this.time;
            if (this.time >= 100) {
                this.remove(Entity.RemovalReason.KILLED);
            }
            if (this.time >= 20 && !this.hasAimed) {
                this.reAim();
            }
            if ((hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0))).getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.onHit(hitresult);
            }
            while (!this.isRemoved()) {
                EntityHitResult entityhitresult = this.findHitEntity(this.position(), this.position().add(this.getDeltaMovement()));
                if (entityhitresult != null) {
                    hitresult = entityhitresult;
                }
                if (hitresult != null && hitresult.getType() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)hitresult).getEntity();
                    Entity entity1 = this.getOwner();
                    if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).canHarmPlayer((Player)entity)) {
                        hitresult = null;
                        entityhitresult = null;
                    }
                }
                if (hitresult != null && hitresult.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                    this.onHit(hitresult);
                    this.hasImpulse = true;
                }
                if (entityhitresult != null) {
                    hitresult = null;
                    continue;
                }
                break;
            }
        } else {
            for (double i = 0.0; i < 3.0; i += 1.0) {
                for (int o = 0; o < 2; ++o) {
                    Vec3 pos = this.position();
                    pos = pos.subtract(this.getDeltaMovement().x * (i / 3.0), this.getDeltaMovement().y * (i / 3.0), this.getDeltaMovement().z * (i / 3.0));
                    pos = pos.add(0.0, this.getBoundingBox().getYsize() / 2.0, 0.0);
                    pos = pos.add((double)Mth.nextFloat((RandomSource)this.random, (float)-0.1f, (float)0.1f), (double)Mth.nextFloat((RandomSource)this.random, (float)-0.1f, (float)0.1f), (double)Mth.nextFloat((RandomSource)this.random, (float)-0.1f, (float)0.1f));
                    ClientMethods.particle(this.random, pos, this.level());
                }
            }
        }
        super.tick();
    }

    protected void onHitEntity(EntityHitResult hit) {
        Entity entity;
        boolean flag;
        DamageSource damagesource;
        super.onHitEntity(hit);
        Entity entity2 = this.getOwner();
        if (entity2 == hit.getEntity()) {
            this.remove(Entity.RemovalReason.KILLED);
            return;
        }
        if (entity2 instanceof LivingEntity) {
            damagesource = this.damageSources().source(DamageTypeRegistry.ancientProjectile, (Entity)this, entity2);
            ((LivingEntity)entity2).setLastHurtMob(hit.getEntity());
        } else if (entity2 instanceof Player) {
            damagesource = this.damageSources().source(DamageTypeRegistry.ancientProjectile, (Entity)this, entity2);
            ((LivingEntity)entity2).setLastHurtMob(hit.getEntity());
        } else {
            damagesource = null;
        }
        boolean bl = flag = hit.getEntity().getType() == EntityType.ENDERMAN;
        if (damagesource != null && (entity = hit.getEntity()) instanceof LivingEntity) {
            LivingEntity ent = (LivingEntity)entity;
            if (entity2 instanceof LivingEntity && ent.hurt(damagesource, 2.0f) && flag) {
                return;
            }
        }
        this.remove(Entity.RemovalReason.KILLED);
    }

    public static class ClientMethods {
        public static void particle(RandomSource random, Vec3 pos, Level level) {
            for (int i = 0; i < 3; ++i) {
                Vec3 offset = new Vec3((double)Mth.nextFloat((RandomSource)random, (float)-1.0f, (float)1.0f), (double)Mth.nextFloat((RandomSource)random, (float)-1.0f, (float)1.0f), (double)Mth.nextFloat((RandomSource)random, (float)-1.0f, (float)1.0f)).normalize().multiply((double)0.1f, (double)0.1f, (double)0.1f);
                level.addParticle((ParticleOptions)new CircleParticleOptions().setColor(Color.getHSBColor((float)(level.getGameTime() % 100L) / 100.0f, 1.0f, 1.0f)).setAdditive(true), pos.x + offset.x, pos.y + offset.y, pos.z + offset.z, 0.0, 0.0, 0.0);
            }
        }
    }
}

