/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.datagen.loot;

import com.cmdpro.datanessence.registry.BlockRegistry;
import com.cmdpro.datanessence.registry.ItemRegistry;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class ModBlockLootTables
extends BlockLootSubProvider {
    public ModBlockLootTables(HolderLookup.Provider provider) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
    }

    protected void generate() {
        this.dropSelf(BlockRegistry.FABRICATOR.get());
        this.dropSelf(BlockRegistry.ESSENCE_POINT.get());
        this.dropSelf(BlockRegistry.LUNAR_ESSENCE_POINT.get());
        this.dropSelf(BlockRegistry.NATURAL_ESSENCE_POINT.get());
        this.dropSelf(BlockRegistry.EXOTIC_ESSENCE_POINT.get());
        this.dropSelf(BlockRegistry.ESSENCE_BUFFER.get());
        this.dropSelf(BlockRegistry.ITEM_BUFFER.get());
        this.dropSelf(BlockRegistry.FLUID_BUFFER.get());
        this.dropSelf(BlockRegistry.ITEM_POINT.get());
        this.dropSelf(BlockRegistry.FLUID_POINT.get());
        this.dropSelf(BlockRegistry.ESSENCE_CRYSTAL.get());
        this.dropSelf(BlockRegistry.ESSENCE_BURNER.get());
        this.dropSelf(BlockRegistry.DECO_ESSENCE_BUFFER.get());
        this.dropSelf(BlockRegistry.DECO_ITEM_BUFFER.get());
        this.dropSelf(BlockRegistry.DECO_FLUID_BUFFER.get());
        this.add(BlockRegistry.ANCIENT_DATA_BANK.get(), block -> ModBlockLootTables.noDrop());
        this.add(BlockRegistry.COMPUTER.get(), block -> ModBlockLootTables.noDrop());
        this.add(BlockRegistry.CRYOCHAMBER.get(), block -> ModBlockLootTables.noDrop());
        this.add(BlockRegistry.CRYOCHAMBER_FILLER.get(), block -> ModBlockLootTables.noDrop());
        this.add(BlockRegistry.EMPTY_CRYOCHAMBER.get(), block -> ModBlockLootTables.noDrop());
        this.add(BlockRegistry.EMPTY_CRYOCHAMBER_ROUTER.get(), block -> ModBlockLootTables.noDrop());
        this.add(BlockRegistry.ESSENCE_CRYSTAL.get(), block -> this.createEssenceCrystalDrops((Block)block, ItemRegistry.ESSENCE_SHARD.get()));
        this.dropOther(BlockRegistry.ANCIENT_ROCK_COLUMN.get(), (ItemLike)BlockRegistry.SHIELDLESS_ANCIENT_ROCK_COLUMN.get().asItem());
        this.dropOther(BlockRegistry.ANCIENT_ROCK_BRICKS.get(), (ItemLike)BlockRegistry.SHIELDLESS_ANCIENT_ROCK_BRICKS.get().asItem());
        this.dropOther(BlockRegistry.ANCIENT_ROCK_TILES.get(), (ItemLike)BlockRegistry.SHIELDLESS_ANCIENT_ROCK_TILES.get().asItem());
        this.dropOther(BlockRegistry.ENERGIZED_ANCIENT_ROCK_COLUMN.get(), (ItemLike)BlockRegistry.SHIELDLESS_ENERGIZED_ANCIENT_ROCK_COLUMN.get().asItem());
        this.dropOther(BlockRegistry.ANCIENT_LANTERN.get(), (ItemLike)BlockRegistry.SHIELDLESS_ANCIENT_LANTERN.get().asItem());
        this.dropOther(BlockRegistry.ANCIENT_SHELF.get(), (ItemLike)BlockRegistry.SHIELDLESS_ANCIENT_SHELF.get().asItem());
        this.dropOther(BlockRegistry.ANCIENT_WINDOW.get(), (ItemLike)BlockRegistry.SHIELDLESS_ANCIENT_WINDOW.get().asItem());
        this.dropOther(BlockRegistry.ANCIENT_GLYPH_STONE_BLANK.get(), (ItemLike)BlockRegistry.SHIELDLESS_ANCIENT_GLYPH_STONE_BLANK.get().asItem());
        this.dropOther(BlockRegistry.ANCIENT_GLYPH_STONE_MAKUTUIN.get(), (ItemLike)BlockRegistry.SHIELDLESS_ANCIENT_GLYPH_STONE_MAKUTUIN.get().asItem());
        this.dropOther(BlockRegistry.ANCIENT_GLYPH_STONE_ESSENCE.get(), (ItemLike)BlockRegistry.SHIELDLESS_ANCIENT_GLYPH_STONE_ESSENCE.get().asItem());
        this.dropSelf(BlockRegistry.SHIELDLESS_ANCIENT_ROCK_COLUMN.get());
        this.dropSelf(BlockRegistry.SHIELDLESS_ANCIENT_ROCK_BRICKS.get());
        this.dropSelf(BlockRegistry.SHIELDLESS_ANCIENT_ROCK_TILES.get());
        this.dropSelf(BlockRegistry.SHIELDLESS_ENERGIZED_ANCIENT_ROCK_COLUMN.get());
        this.dropSelf(BlockRegistry.SHIELDLESS_ANCIENT_LANTERN.get());
        this.dropSelf(BlockRegistry.SHIELDLESS_ANCIENT_SHELF.get());
        this.dropSelf(BlockRegistry.SHIELDLESS_ANCIENT_WINDOW.get());
        this.dropSelf(BlockRegistry.SHIELDLESS_ANCIENT_GLYPH_STONE_BLANK.get());
        this.dropSelf(BlockRegistry.SHIELDLESS_ANCIENT_GLYPH_STONE_MAKUTUIN.get());
        this.dropSelf(BlockRegistry.SHIELDLESS_ANCIENT_GLYPH_STONE_ESSENCE.get());
        this.dropSelf(BlockRegistry.POLISHED_OBSIDIAN.get());
        this.dropSelf(BlockRegistry.POLISHED_OBSIDIAN_BRICKS.get());
        this.dropSelf(BlockRegistry.POLISHED_OBSIDIAN_TRACT.get());
        this.dropSelf(BlockRegistry.POLISHED_OBSIDIAN_TILES.get());
        this.dropSelf(BlockRegistry.POLISHED_OBSIDIAN_COLUMN.get());
        this.dropSelf(BlockRegistry.ENGRAVED_POLISHED_OBSIDIAN.get());
        this.dropSelf(BlockRegistry.TRAVERSITE_ROAD.get());
        this.dropSelf(BlockRegistry.ESSENCE_BATTERY.get());
        this.dropSelf(BlockRegistry.LUNAR_ESSENCE_BATTERY.get());
        this.dropSelf(BlockRegistry.NATURAL_ESSENCE_BATTERY.get());
        this.dropSelf(BlockRegistry.EXOTIC_ESSENCE_BATTERY.get());
        this.dropSelf(BlockRegistry.INFUSER.get());
        this.dropSelf(BlockRegistry.PATTERNED_COPPER.get());
        this.dropSelf(BlockRegistry.FLUID_COLLECTOR.get());
        this.dropSelf(BlockRegistry.FLUID_SPILLER.get());
        this.dropSelf(BlockRegistry.CHARGER.get());
        this.dropSelf(BlockRegistry.LASER_EMITTER.get());
        this.dropSelf(BlockRegistry.VACUUM.get());
        this.add(BlockRegistry.STRUCTURE_PROTECTOR.get(), block -> ModBlockLootTables.noDrop());
        this.dropSelf(BlockRegistry.ESSENCE_LEECH.get());
        this.add(BlockRegistry.LENSING_CRYSTAL_ORE.get(), block -> this.createLensingCrystalDrops((Block)block, ItemRegistry.LENSING_CRYSTAL.get()));
        this.dropSelf(BlockRegistry.AUTO_FABRICATOR.get());
        this.dropSelf(BlockRegistry.FLUID_TANK.get());
        this.dropSelf(BlockRegistry.FLUID_MIXER.get());
        this.dropSelf(BlockRegistry.SYNTHESIS_CHAMBER.get());
        this.dropSelf(BlockRegistry.FLUID_BOTTLER.get());
        this.dropSelf(BlockRegistry.ENTROPIC_PROCESSOR.get());
        this.dropSelf(BlockRegistry.ESSENCE_FURNACE.get());
        this.dropSelf(BlockRegistry.ENTICING_LURE.get());
        this.dropSelf(BlockRegistry.FLUIDIC_GLASS.get());
        this.dropSelf(BlockRegistry.AETHER_RUNE.get());
        this.dropSelf(BlockRegistry.MINERAL_PURIFICATION_CHAMBER.get());
        this.dropSelf(BlockRegistry.ITEM_FILTER.get());
        this.dropSelf(BlockRegistry.ESSENCE_BREAKER.get());
        this.dropSelf(BlockRegistry.LIMITED_ITEM_BUFFER.get());
        this.dropSelf(BlockRegistry.SPIRE_GLASS.get());
        this.dropSelf(BlockRegistry.METAL_SHAPER.get());
        this.dropSelf(BlockRegistry.LIGHT_FIXTURE.get());
        this.dropSelf(BlockRegistry.CRYSTALLINE_LEAVES.get());
        this.dropSelf(BlockRegistry.CRYSTALLINE_LOG.get());
        this.dropSelf(BlockRegistry.INDUSTRIAL_PLANT_SIPHON.get());
        this.dropSelf(BlockRegistry.MELTER.get());
        this.dropSelf(BlockRegistry.TRAVERSITE_ROAD_SLAB.get());
        this.dropSelf(BlockRegistry.TRAVERSITE_ROAD_STAIRS.get());
        this.dropSelf(BlockRegistry.CHEMICAL_NODE.get());
        this.dropSelf(BlockRegistry.DEWLAMP.get());
        this.dropSelf(BlockRegistry.DRYING_TABLE.get());
        this.dropSelf(BlockRegistry.TRAVERSITE_ROAD_OPAL.get());
        this.dropSelf(BlockRegistry.TRAVERSITE_ROAD_STAIRS_OPAL.get());
        this.dropSelf(BlockRegistry.TRAVERSITE_ROAD_SLAB_OPAL.get());
        this.dropSelf(BlockRegistry.ESSENCE_BRIDGE.get());
        this.dropSelf(BlockRegistry.DATA_BANK.get());
        this.dropSelf(BlockRegistry.ENDER_PEARL_DESTINATION.get());
        this.dropSelf(BlockRegistry.ENDER_PEARL_RELAY.get());
        this.dropSelf(BlockRegistry.ENDER_PEARL_CAPTURE.get());
        this.add(BlockRegistry.CREATIVE_ESSENCE_BATTERY.get(), block -> ModBlockLootTables.noDrop());
        this.dropSelf(BlockRegistry.OBSIDIAN_FRAMED_GLASS.get());
        this.add(BlockRegistry.TETHERGRASS.get(), block -> this.createTethergrassDrops((Block)block, ItemRegistry.BONDING_POWDER.get()));
        this.add(BlockRegistry.AREKKO.get(), block -> this.createArekkoDrops(BlockRegistry.AREKKO.get(), Items.BONE));
    }

    protected LootTable.Builder createEssenceCrystalDrops(Block pBlock, Item item) {
        return this.createSilkTouchDispatchTable(pBlock, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)pBlock, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE)))));
    }

    protected LootTable.Builder createTethergrassDrops(Block pBlock, Item item) {
        return this.createSilkTouchOrShearsDispatchTable(pBlock, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)pBlock, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE)))));
    }

    protected LootTable.Builder createArekkoDrops(Block pBlock, Item item) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)pBlock, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))))));
    }

    protected LootTable.Builder createLensingCrystalDrops(Block pBlock, Item item) {
        return this.createSilkTouchDispatchTable(pBlock, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)pBlock, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE)))));
    }

    protected Iterable<Block> getKnownBlocks() {
        return BlockRegistry.BLOCKS.getEntries().stream().map(block -> (Block)block.get()).filter(block -> !(block instanceof LiquidBlock))::iterator;
    }
}

