/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.datagen;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.block.DirectionalPillarBlock;
import com.cmdpro.datanessence.block.auxiliary.LaserEmitter;
import com.cmdpro.datanessence.block.generation.EssenceBurner;
import com.cmdpro.datanessence.block.production.FluidCollector;
import com.cmdpro.datanessence.registry.BlockRegistry;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "datanessence", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.bufferBlock(BlockRegistry.ESSENCE_BUFFER);
        this.bufferBlock(BlockRegistry.ITEM_BUFFER);
        this.bufferBlock(BlockRegistry.LIMITED_ITEM_BUFFER);
        this.bufferBlock(BlockRegistry.FLUID_BUFFER);
        this.ancientDecoBlockWithItem(BlockRegistry.ANCIENT_ROCK_BRICKS);
        this.ancientDecoBlockWithItem(BlockRegistry.ANCIENT_ROCK_TILES);
        this.ancientDecoCubeColumn(BlockRegistry.ANCIENT_ROCK_COLUMN);
        this.ancientDecoCubeColumn(BlockRegistry.ENERGIZED_ANCIENT_ROCK_COLUMN);
        this.ancientDecoBlockWithItem(BlockRegistry.ANCIENT_LANTERN);
        this.ancientShelf(BlockRegistry.ANCIENT_SHELF);
        this.transparentAncientDecoBlockWithItem(BlockRegistry.ANCIENT_WINDOW);
        this.ancientDecoBlockWithItem(BlockRegistry.ANCIENT_GLYPH_STONE_BLANK);
        this.ancientDecoBlockWithItem(BlockRegistry.ANCIENT_GLYPH_STONE_MAKUTUIN);
        this.ancientDecoBlockWithItem(BlockRegistry.ANCIENT_GLYPH_STONE_ESSENCE);
        this.parentedBlockWithItem(BlockRegistry.SHIELDLESS_ANCIENT_ROCK_BRICKS, DataNEssence.locate("ancient_rock_bricks"));
        this.parentedBlockWithItem(BlockRegistry.SHIELDLESS_ANCIENT_ROCK_TILES, DataNEssence.locate("ancient_rock_tiles"));
        this.parentedBlockWithItem(BlockRegistry.SHIELDLESS_ANCIENT_ROCK_COLUMN, DataNEssence.locate("ancient_rock_column"));
        this.parentedBlockWithItem(BlockRegistry.SHIELDLESS_ENERGIZED_ANCIENT_ROCK_COLUMN, DataNEssence.locate("energized_ancient_rock_column"));
        this.parentedBlockWithItem(BlockRegistry.SHIELDLESS_ANCIENT_LANTERN, DataNEssence.locate("ancient_lantern"));
        this.parentedBlockWithItem(BlockRegistry.SHIELDLESS_ANCIENT_WINDOW, DataNEssence.locate("ancient_window"));
        this.parentedBlockWithItem(BlockRegistry.SHIELDLESS_ANCIENT_GLYPH_STONE_BLANK, DataNEssence.locate("ancient_glyph_stone_blank"));
        this.parentedBlockWithItem(BlockRegistry.SHIELDLESS_ANCIENT_GLYPH_STONE_ESSENCE, DataNEssence.locate("ancient_glyph_stone_essence"));
        this.parentedBlockWithItem(BlockRegistry.SHIELDLESS_ANCIENT_GLYPH_STONE_MAKUTUIN, DataNEssence.locate("ancient_glyph_stone_makutuin"));
        this.bufferDecoBlock(BlockRegistry.DECO_ESSENCE_BUFFER);
        this.bufferDecoBlock(BlockRegistry.DECO_ITEM_BUFFER);
        this.bufferDecoBlock(BlockRegistry.DECO_FLUID_BUFFER);
        this.decoBlock(BlockRegistry.POLISHED_OBSIDIAN);
        this.decoBlock(BlockRegistry.POLISHED_OBSIDIAN_BRICKS);
        this.decoBlock(BlockRegistry.POLISHED_OBSIDIAN_TILES);
        this.pillarDecoBlock(BlockRegistry.POLISHED_OBSIDIAN_COLUMN);
        this.pillarDecoBlock(BlockRegistry.POLISHED_OBSIDIAN_TRACT);
        this.decoBlock(BlockRegistry.ENGRAVED_POLISHED_OBSIDIAN);
        this.decoBlock(BlockRegistry.PATTERNED_COPPER);
        this.transparentDecoBlockWithItem(BlockRegistry.FLUIDIC_GLASS);
        this.transparentDecoBlockWithItem(BlockRegistry.OBSIDIAN_FRAMED_GLASS);
        this.decoBlock(BlockRegistry.AETHER_RUNE);
        this.essenceBurner(BlockRegistry.ESSENCE_BURNER);
        this.dataBank(BlockRegistry.ANCIENT_DATA_BANK);
        this.fluidCollector(BlockRegistry.FLUID_COLLECTOR);
        this.fluidCollector(BlockRegistry.FLUID_SPILLER);
        this.laserEmitter(BlockRegistry.LASER_EMITTER);
        this.essenceBattery(BlockRegistry.ESSENCE_BATTERY);
        this.itemFilter(BlockRegistry.ITEM_FILTER);
        this.crystallineLog(BlockRegistry.CRYSTALLINE_LOG);
        this.essenceLeech(BlockRegistry.ESSENCE_LEECH);
        this.essenceFurnace(BlockRegistry.ESSENCE_FURNACE);
        this.mineralPurificationChamber(BlockRegistry.MINERAL_PURIFICATION_CHAMBER);
        this.synthesisChamber(BlockRegistry.SYNTHESIS_CHAMBER);
        this.nothing(BlockRegistry.STRUCTURE_PROTECTOR);
        this.blockWithItem(BlockRegistry.TRAVERSITE_ROAD);
        this.blockWithItem(BlockRegistry.LENSING_CRYSTAL_ORE);
        this.blockWithItem(BlockRegistry.CREATIVE_ESSENCE_BATTERY);
        this.transparentBlockWithItemAndTint(BlockRegistry.SPIRE_GLASS);
        this.stairsBlock((StairBlock)BlockRegistry.TRAVERSITE_ROAD_STAIRS.get(), DataNEssence.locate("block/traversite_road"));
        this.slabBlock((SlabBlock)BlockRegistry.TRAVERSITE_ROAD_SLAB.get(), DataNEssence.locate("block/traversite_road"), DataNEssence.locate("block/traversite_road"));
        this.blockWithItemTintedOverlay(BlockRegistry.TRAVERSITE_ROAD_OPAL, ResourceLocation.fromNamespaceAndPath((String)"opalescence", (String)"block/opal"), DataNEssence.locate("block/traversite_road_opal_overlay"), DataNEssence.locate("block/traversite_road"));
        this.stairsBlockTintedOverlay((StairBlock)BlockRegistry.TRAVERSITE_ROAD_STAIRS_OPAL.get(), ResourceLocation.fromNamespaceAndPath((String)"opalescence", (String)"block/opal"), DataNEssence.locate("block/traversite_road_opal_overlay"), DataNEssence.locate("block/traversite_road"));
        this.slabBlockTintedOverlay((SlabBlock)BlockRegistry.TRAVERSITE_ROAD_SLAB_OPAL.get(), DataNEssence.locate("block/traversite_road_opal"), ResourceLocation.fromNamespaceAndPath((String)"opalescence", (String)"block/opal"), DataNEssence.locate("block/traversite_road_opal_overlay"), DataNEssence.locate("block/traversite_road"));
    }

    public void slabBlockTintedOverlay(SlabBlock block, ResourceLocation doubleSlab, ResourceLocation texture, ResourceLocation overlay, ResourceLocation particle) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)block);
        ModelBuilder slab = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(loc.getPath(), ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)"block/slab_tinted_overlay"))).texture("side", texture)).texture("bottom", texture)).texture("top", texture)).texture("sideoverlay", overlay)).texture("bottomoverlay", overlay)).texture("topoverlay", overlay)).texture("particle", particle);
        ModelBuilder slabTop = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(loc.getPath() + "_top", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)"block/slab_top_tinted_overlay"))).texture("side", texture)).texture("bottom", texture)).texture("top", texture)).texture("sideoverlay", overlay)).texture("bottomoverlay", overlay)).texture("topoverlay", overlay)).texture("particle", particle);
        this.slabBlock(block, (ModelFile)slab, (ModelFile)slabTop, (ModelFile)this.models().getExistingFile(doubleSlab));
    }

    private void stairsBlockTintedOverlay(StairBlock block, ResourceLocation texture, ResourceLocation overlay, ResourceLocation particle) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)block);
        ModelBuilder stairs = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(loc.getPath(), ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)"block/stairs_tinted_overlay"))).texture("side", texture)).texture("bottom", texture)).texture("top", texture)).texture("sideoverlay", overlay)).texture("bottomoverlay", overlay)).texture("topoverlay", overlay)).texture("particle", particle);
        ModelBuilder stairsInner = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(loc.getPath() + "_inner", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)"block/inner_stairs_tinted_overlay"))).texture("side", texture)).texture("bottom", texture)).texture("top", texture)).texture("sideoverlay", overlay)).texture("bottomoverlay", overlay)).texture("topoverlay", overlay)).texture("particle", particle);
        ModelBuilder stairsOuter = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(loc.getPath() + "_outer", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)"block/outer_stairs_tinted_overlay"))).texture("side", texture)).texture("bottom", texture)).texture("top", texture)).texture("sideoverlay", overlay)).texture("bottomoverlay", overlay)).texture("topoverlay", overlay)).texture("particle", particle);
        this.stairsBlock(block, (ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter);
    }

    private void blockWithItemTintedOverlay(Supplier<Block> blockRegistryObject, ResourceLocation texture, ResourceLocation overlay, ResourceLocation particle) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        ModelBuilder cube = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(loc.getPath(), ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)"block/cube_all_tinted_overlay"))).texture("all", texture)).texture("overlay", overlay)).texture("particle", particle);
        this.simpleBlockWithItem(blockRegistryObject.get(), (ModelFile)cube);
    }

    private void blockWithItem(Supplier<Block> blockRegistryObject) {
        this.simpleBlockWithItem(blockRegistryObject.get(), this.cubeAll(blockRegistryObject.get()));
    }

    private void blockWithItemWithVariants(Supplier<Block> blockRegistryObject, String ... variantPostfixes) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        ArrayList<ModelBuilder> variants = new ArrayList<ModelBuilder>();
        for (String i : variantPostfixes) {
            variants.add(this.models().cubeAll(loc.getPath() + "_" + i, ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_" + i))));
        }
        this.simpleBlockItem(blockRegistryObject.get(), (ModelFile)variants.getFirst());
        this.simpleBlock(blockRegistryObject.get(), variants.stream().map(ConfiguredModel::new).toList().toArray(new ConfiguredModel[0]));
    }

    private void ancientDecoBlockWithItemWithVariants(Supplier<Block> blockRegistryObject, String ... variantPostfixes) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        ArrayList<ModelBuilder> variants = new ArrayList<ModelBuilder>();
        for (String i : variantPostfixes) {
            variants.add(this.models().cubeAll(loc.getPath() + "_" + i, ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/deco/ancient/" + loc.getPath() + "_" + i))));
        }
        this.simpleBlockItem(blockRegistryObject.get(), (ModelFile)variants.getFirst());
        this.simpleBlock(blockRegistryObject.get(), variants.stream().map(ConfiguredModel::new).toList().toArray(new ConfiguredModel[0]));
    }

    private void ancientShelf(Supplier<Block> blockRegistryObject) {
        String[] variantPostfixes = new String[]{"books", "books2", "bottles", "empty", "empty2", "materials"};
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        ArrayList<ModelBuilder> variants = new ArrayList<ModelBuilder>();
        for (String i : variantPostfixes) {
            ResourceLocation side = ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/deco/ancient/" + loc.getPath() + "_" + i));
            ResourceLocation vertical = ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)"block/deco/ancient/ancient_rock_column_vertical");
            variants.add(((BlockModelBuilder)this.models().cube(loc.getPath() + "_" + i, vertical, vertical, side, side, side, side)).texture("particle", vertical));
        }
        this.simpleBlockItem(blockRegistryObject.get(), (ModelFile)variants.getFirst());
        this.simpleBlock(blockRegistryObject.get(), variants.stream().map(ConfiguredModel::new).toList().toArray(new ConfiguredModel[0]));
    }

    private void transparentBlockWithItem(Supplier<Block> blockRegistryObject) {
        this.simpleBlockWithItem(blockRegistryObject.get(), (ModelFile)((BlockModelBuilder)this.models().cubeAll(BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get()).getPath(), this.blockTexture(blockRegistryObject.get()))).renderType("translucent"));
    }

    private void transparentBlockWithItemAndTint(Supplier<Block> blockRegistryObject) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        this.simpleBlockWithItem(blockRegistryObject.get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture(loc.getPath(), ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)"block/cube_all_tinted"), "all", this.blockTexture(blockRegistryObject.get()))).renderType("translucent"));
    }

    private void transparentDecoBlockWithItem(Supplier<Block> blockRegistryObject) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        this.simpleBlockWithItem(blockRegistryObject.get(), (ModelFile)((BlockModelBuilder)this.models().cubeAll(BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get()).getPath(), ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/deco/" + loc.getPath())))).renderType("translucent"));
    }

    private void transparentAncientDecoBlockWithItem(Supplier<Block> blockRegistryObject) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        this.simpleBlockWithItem(blockRegistryObject.get(), (ModelFile)((BlockModelBuilder)this.models().cubeAll(BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get()).getPath(), ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/deco/ancient/" + loc.getPath())))).renderType("translucent"));
    }

    private void cubeColumn(Supplier<Block> blockRegistryObject) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        this.simpleBlockWithItem(blockRegistryObject.get(), (ModelFile)this.models().cubeColumn(loc.getPath(), ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_side")), ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath()))));
    }

    private void crystallineLog(Supplier<Block> blockRegistryObject) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        this.axisBlock((RotatedPillarBlock)blockRegistryObject.get(), ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/deco/" + loc.getPath())), ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/deco/" + loc.getPath() + "_top")));
    }

    private void essenceBattery(Supplier<Block> blockRegistryObject) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        this.simpleBlockWithItem(blockRegistryObject.get(), (ModelFile)this.models().cubeColumn(loc.getPath(), ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_side")), ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_end"))));
    }

    private void ancientDecoBlockWithItem(Supplier<Block> blockRegistryObject) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        this.simpleBlockWithItem(blockRegistryObject.get(), (ModelFile)this.models().cubeAll(loc.getPath(), ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/deco/ancient/" + loc.getPath()))));
    }

    private void ancientDecoCubeColumn(Supplier<Block> blockRegistryObject) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        ResourceLocation side = ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/deco/ancient/" + loc.getPath() + "_side"));
        ResourceLocation vertical = ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/deco/ancient/" + loc.getPath() + "_vertical"));
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(loc.getPath(), "block/cube")).texture("west", side)).texture("east", side)).texture("north", side)).texture("down", vertical)).texture("up", vertical)).texture("south", side)).texture("particle", side);
        this.simpleBlockItem(blockRegistryObject.get(), (ModelFile)model);
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(blockRegistryObject.get()).partialState().with((Property)DirectionalPillarBlock.FACING, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)model).rotationY(90).rotationX(90).addModel()).partialState().with((Property)DirectionalPillarBlock.FACING, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)model).rotationX(90).addModel()).partialState().with((Property)DirectionalPillarBlock.FACING, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)model).rotationY(180).rotationX(90).addModel()).partialState().with((Property)DirectionalPillarBlock.FACING, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)model).rotationY(270).rotationX(90).addModel()).partialState().with((Property)DirectionalPillarBlock.FACING, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)DirectionalPillarBlock.FACING, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)model).rotationX(180).addModel();
    }

    private void bufferBlock(Supplier<Block> blockRegistryObject) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        this.simpleBlockWithItem(blockRegistryObject.get(), (ModelFile)this.models().cubeColumn(loc.getPath(), ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/buffer/" + loc.getPath() + "_side")), ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/buffer/" + loc.getPath() + "_top_bottom"))));
    }

    private void bufferDecoBlock(Supplier<Block> blockRegistryObject) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        this.axisBlock((RotatedPillarBlock)blockRegistryObject.get(), ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/buffer/" + loc.getPath().replaceFirst("deco_", "") + "_side")), ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/buffer/" + loc.getPath().replaceFirst("deco_", "") + "_top_bottom")));
    }

    private void decoBlock(Supplier<Block> blockRegistryObject) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        this.simpleBlockWithItem(blockRegistryObject.get(), (ModelFile)this.models().cubeAll(loc.getPath(), ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/deco/" + loc.getPath()))));
    }

    private void pillarDecoBlock(Supplier<Block> blockRegistryObject) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        ResourceLocation side = ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/deco/" + loc.getPath() + "_side"));
        ResourceLocation vertical = ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/deco/" + loc.getPath() + "_vertical"));
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(loc.getPath(), "block/cube")).texture("west", side)).texture("east", side)).texture("north", side)).texture("down", vertical)).texture("up", vertical)).texture("south", side)).texture("particle", side);
        this.simpleBlockItem(blockRegistryObject.get(), (ModelFile)model);
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(blockRegistryObject.get()).partialState().with((Property)DirectionalPillarBlock.FACING, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)model).rotationY(90).rotationX(90).addModel()).partialState().with((Property)DirectionalPillarBlock.FACING, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)model).rotationX(90).addModel()).partialState().with((Property)DirectionalPillarBlock.FACING, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)model).rotationY(180).rotationX(90).addModel()).partialState().with((Property)DirectionalPillarBlock.FACING, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)model).rotationY(270).rotationX(90).addModel()).partialState().with((Property)DirectionalPillarBlock.FACING, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)DirectionalPillarBlock.FACING, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)model).rotationX(180).addModel();
    }

    private void essenceLeech(Supplier<Block> blockRegistryObject) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(loc.getPath(), "block/cube")).texture("west", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_side")))).texture("east", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_side")))).texture("north", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_side")))).texture("down", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_bottom")))).texture("up", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_top")))).texture("south", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_side")))).texture("particle", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_side")));
        this.simpleBlockWithItem(blockRegistryObject.get(), (ModelFile)model);
    }

    private void essenceBurner(Supplier<Block> blockRegistryObject) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(loc.getPath(), "block/cube")).texture("west", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_side")))).texture("east", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_side")))).texture("north", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_front")))).texture("down", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)"block/deco/polished_obsidian"))).texture("up", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_top")))).texture("south", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_back")))).texture("particle", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_front")));
        BlockModelBuilder modelLit = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(loc.getPath() + "_lit", "block/cube")).texture("west", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_side")))).texture("east", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_side")))).texture("north", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_front_on")))).texture("down", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)"block/deco/polished_obsidian"))).texture("up", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_top_on")))).texture("south", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_back")))).texture("particle", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_front_on")));
        this.simpleBlockItem(blockRegistryObject.get(), (ModelFile)model);
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(blockRegistryObject.get()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.EAST).with((Property)EssenceBurner.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)model).rotationY(90).addModel()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.NORTH).with((Property)EssenceBurner.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.SOUTH).with((Property)EssenceBurner.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)model).rotationY(180).addModel()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.WEST).with((Property)EssenceBurner.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)model).rotationY(270).addModel()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.EAST).with((Property)EssenceBurner.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)modelLit).rotationY(90).addModel()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.NORTH).with((Property)EssenceBurner.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)modelLit).addModel()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.SOUTH).with((Property)EssenceBurner.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)modelLit).rotationY(180).addModel()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.WEST).with((Property)EssenceBurner.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)modelLit).rotationY(270).addModel();
    }

    private void mineralPurificationChamber(Supplier<Block> blockRegistryObject) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(loc.getPath(), "block/cube")).texture("west", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_side")))).texture("east", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_side")))).texture("north", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_front")))).texture("down", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_bottom")))).texture("up", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_top")))).texture("south", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_side")))).texture("particle", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_front")));
        this.simpleBlockItem(blockRegistryObject.get(), (ModelFile)model);
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(blockRegistryObject.get()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)model).rotationY(90).addModel()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)model).rotationY(180).addModel()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)model).rotationY(270).addModel();
    }

    private void synthesisChamber(Supplier<Block> blockRegistryObject) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(loc.getPath(), "block/cube")).texture("west", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_side")))).texture("east", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_side")))).texture("north", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_front")))).texture("down", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)"block/deco/polished_obsidian"))).texture("up", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_top")))).texture("south", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_side")))).texture("particle", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_front")));
        this.simpleBlockItem(blockRegistryObject.get(), (ModelFile)model);
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(blockRegistryObject.get()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)model).rotationY(90).addModel()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)model).rotationY(180).addModel()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)model).rotationY(270).addModel();
    }

    private void essenceFurnace(Supplier<Block> blockRegistryObject) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(loc.getPath(), "block/cube")).texture("west", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_side")))).texture("east", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_side")))).texture("north", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_front")))).texture("down", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)"block/deco/patterned_copper"))).texture("up", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_top")))).texture("south", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_side")))).texture("particle", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_front")));
        BlockModelBuilder modelLit = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(loc.getPath() + "_lit", "block/cube")).texture("west", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_side")))).texture("east", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_side")))).texture("north", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_front_on")))).texture("down", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)"block/deco/patterned_copper"))).texture("up", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_top")))).texture("south", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_side")))).texture("particle", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_front_on")));
        this.simpleBlockItem(blockRegistryObject.get(), (ModelFile)model);
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(blockRegistryObject.get()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.EAST).with((Property)EssenceBurner.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)model).rotationY(90).addModel()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.NORTH).with((Property)EssenceBurner.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.SOUTH).with((Property)EssenceBurner.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)model).rotationY(180).addModel()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.WEST).with((Property)EssenceBurner.LIT, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)model).rotationY(270).addModel()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.EAST).with((Property)EssenceBurner.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)modelLit).rotationY(90).addModel()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.NORTH).with((Property)EssenceBurner.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)modelLit).addModel()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.SOUTH).with((Property)EssenceBurner.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)modelLit).rotationY(180).addModel()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.WEST).with((Property)EssenceBurner.LIT, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)modelLit).rotationY(270).addModel();
    }

    private void itemFilter(Supplier<Block> blockRegistryObject) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(loc.getPath(), "block/cube")).texture("west", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_west")))).texture("east", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_east")))).texture("north", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_north")))).texture("down", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_bottom")))).texture("up", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_top")))).texture("south", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_south")))).texture("particle", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_top")));
        this.simpleBlockWithItem(blockRegistryObject.get(), (ModelFile)model);
    }

    private void dataBank(Supplier<Block> blockRegistryObject) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(loc.getPath(), "block/cube")).texture("west", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)"block/deco/ancient/ancient_rock_bricks"))).texture("east", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)"block/deco/ancient/ancient_rock_bricks"))).texture("north", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_front")))).texture("down", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)"block/deco/ancient/ancient_rock_bricks"))).texture("up", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)"block/deco/ancient/ancient_rock_bricks"))).texture("south", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)"block/deco/ancient/ancient_rock_bricks"))).texture("particle", ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_front")));
        this.simpleBlockItem(blockRegistryObject.get(), (ModelFile)model);
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(blockRegistryObject.get()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)model).rotationY(90).addModel()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)model).rotationY(180).addModel()).partialState().with((Property)EssenceBurner.FACING, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)model).rotationY(270).addModel();
    }

    private void fluidCollector(Supplier<Block> blockRegistryObject) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(blockRegistryObject.get());
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        ResourceLocation side = ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_side"));
        ResourceLocation bottom = ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_bottom"));
        ResourceLocation top = ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_top"));
        ResourceLocation pump = ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_pump"));
        ResourceLocation pumpTop = ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_pump_top"));
        ResourceLocation pumpBottom = ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_pump_bottom"));
        for (Direction i : Direction.values()) {
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(loc.getPath() + "_" + i.getName().toLowerCase(), "block/cube")).texture("west", i == Direction.WEST ? pump : side)).texture("east", i == Direction.EAST ? pump : side)).texture("north", i == Direction.NORTH ? pump : side)).texture("south", i == Direction.SOUTH ? pump : side)).texture("down", i == Direction.DOWN ? pumpBottom : bottom)).texture("up", i == Direction.UP ? pumpTop : top)).texture("particle", side);
            builder.partialState().with((Property)FluidCollector.FACING, (Comparable)i).modelForState().modelFile((ModelFile)model).addModel();
        }
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(loc.getPath() + "_hand", "block/cube")).texture("west", side)).texture("east", side)).texture("north", side)).texture("south", side)).texture("down", pumpBottom)).texture("up", top)).texture("particle", side);
        this.simpleBlockItem(blockRegistryObject.get(), (ModelFile)model);
    }

    private void laserEmitter(Supplier<Block> blockRegistryObject) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        ResourceLocation side = ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_side"));
        ResourceLocation back = ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_back"));
        ResourceLocation front = ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_front"));
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(loc.getPath(), "block/cube")).texture("west", side)).texture("east", side)).texture("north", side)).texture("down", back)).texture("up", front)).texture("south", side)).texture("particle", side);
        this.simpleBlockItem(blockRegistryObject.get(), (ModelFile)model);
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(blockRegistryObject.get()).partialState().with((Property)LaserEmitter.FACING, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)model).rotationY(90).rotationX(90).addModel()).partialState().with((Property)LaserEmitter.FACING, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)model).rotationX(90).addModel()).partialState().with((Property)LaserEmitter.FACING, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)model).rotationY(180).rotationX(90).addModel()).partialState().with((Property)LaserEmitter.FACING, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)model).rotationY(270).rotationX(90).addModel()).partialState().with((Property)LaserEmitter.FACING, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)LaserEmitter.FACING, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)model).rotationX(180).addModel();
    }

    private void nothing(Supplier<Block> blockRegistryObject) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        ResourceLocation particle = ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)"block/nothing");
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(loc.getPath())).texture("particle", particle);
        this.simpleBlock(blockRegistryObject.get(), (ModelFile)model);
    }

    private void parentedBlock(Supplier<Block> blockRegistryObject, ResourceLocation parent) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        this.simpleBlock(blockRegistryObject.get(), (ModelFile)this.models().withExistingParent(loc.getPath(), parent));
    }

    private void parentedBlockWithItem(Supplier<Block> blockRegistryObject, ResourceLocation parent) {
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)blockRegistryObject.get());
        this.simpleBlockWithItem(blockRegistryObject.get(), (ModelFile)this.models().withExistingParent(loc.getPath(), parent));
    }
}

