/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.data.pinging;

import com.cmdpro.datanessence.api.DataNEssenceRegistries;
import com.cmdpro.datanessence.api.computer.ComputerFile;
import com.cmdpro.datanessence.api.computer.ComputerFileType;
import com.cmdpro.datanessence.data.pinging.PingableStructure;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.Structure;

public class PingableStructureSerializer {
    public static final Codec<ComputerFile> FILE_CODEC = DataNEssenceRegistries.COMPUTER_FILE_TYPES_REGISTRY.byNameCodec().dispatch(ComputerFile::getType, computerFileType -> computerFileType.getCodec());
    public static final StreamCodec<RegistryFriendlyByteBuf, ComputerFile> FILE_STREAM_CODEC = StreamCodec.of((pBuffer, pValue) -> {
        pBuffer.writeResourceLocation(DataNEssenceRegistries.COMPUTER_FILE_TYPES_REGISTRY.getKey((Object)pValue.getType()));
        pValue.getType().getStreamCodec().encode(pBuffer, pValue);
    }, pBuffer -> {
        ResourceLocation type = pBuffer.readResourceLocation();
        ComputerFileType minigameSerializer = (ComputerFileType)DataNEssenceRegistries.COMPUTER_FILE_TYPES_REGISTRY.get(type);
        ComputerFile page = (ComputerFile)minigameSerializer.getStreamCodec().decode(pBuffer);
        return page;
    });
    public static final MapCodec<PingableStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.STRUCTURE).fieldOf("structure").forGetter(data -> data.structure), (App)ResourceKey.codec((ResourceKey)Registries.ADVANCEMENT).fieldOf("advancement").forGetter(data -> data.advancement), (App)ResourceKey.codec((ResourceKey)Registries.ADVANCEMENT).optionalFieldOf("requiredAdvancement").forGetter(data -> data.requiredAdvancement), (App)Codec.INT.listOf().comapFlatMap(integer -> Util.fixedSize((List)integer, (int)3).map(integers -> new Color((Integer)integers.get(0), (Integer)integers.get(1), (Integer)integers.get(2))), color -> List.of(Integer.valueOf(color.getRed()), Integer.valueOf(color.getGreen()), Integer.valueOf(color.getBlue()))).fieldOf("color1").forGetter(data -> data.color1), (App)Codec.INT.listOf().comapFlatMap(integer -> Util.fixedSize((List)integer, (int)3).map(integers -> new Color((Integer)integers.get(0), (Integer)integers.get(1), (Integer)integers.get(2))), color -> List.of(Integer.valueOf(color.getRed()), Integer.valueOf(color.getGreen()), Integer.valueOf(color.getBlue()))).fieldOf("color2").forGetter(data -> data.color2), (App)PingableStructure.PingableStructureIcon.CODEC.fieldOf("icon").forGetter(data -> data.icon)).apply((Applicative)instance, PingableStructure::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PingableStructure> STREAM_CODEC = StreamCodec.of((pBuffer, pValue) -> {
        pBuffer.writeResourceKey(pValue.structure);
        pBuffer.writeResourceKey(pValue.advancement);
        pBuffer.writeOptional(pValue.requiredAdvancement, FriendlyByteBuf::writeResourceKey);
        pBuffer.writeInt(pValue.color1.getRGB());
        pBuffer.writeInt(pValue.color2.getRGB());
        PingableStructure.PingableStructureIcon.STREAM_CODEC.encode(pBuffer, (Object)pValue.icon);
    }, pBuffer -> {
        ResourceKey structure = pBuffer.readResourceKey(Registries.STRUCTURE);
        ResourceKey advancement = pBuffer.readResourceKey(Registries.ADVANCEMENT);
        Optional requiredAdvancement = pBuffer.readOptional(buf -> buf.readResourceKey(Registries.ADVANCEMENT));
        int color1 = pBuffer.readInt();
        int color2 = pBuffer.readInt();
        PingableStructure.PingableStructureIcon icon = (PingableStructure.PingableStructureIcon)PingableStructure.PingableStructureIcon.STREAM_CODEC.decode(pBuffer);
        PingableStructure data = new PingableStructure((ResourceKey<Structure>)structure, (ResourceKey<Advancement>)advancement, requiredAdvancement, new Color(color1), new Color(color2), icon);
        return data;
    });

    public PingableStructure read(ResourceLocation entryId, JsonObject json) {
        PingableStructure data = (PingableStructure)CODEC.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow();
        return data;
    }
}

