/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.data.minigames;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.databank.Minigame;
import com.cmdpro.datanessence.screen.DataBankScreen;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.geom.Line2D;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import org.joml.Vector2d;
import org.joml.Vector2i;

public class WireMinigame
extends Minigame {
    public static final ResourceLocation TEXTURE = DataNEssence.locate("textures/gui/data_bank_minigames.png");
    public HashMap<Vector2i, Tile> tiles;
    public Vector2d startLine;
    public Vector2d endLine;
    public int lineColor;

    public WireMinigame(Map<Vector2i, Tile> tiles) {
        this.setupTiles();
        this.tiles.putAll(tiles);
    }

    public void setupTiles() {
        this.tiles = new HashMap();
        for (int i = 0; i < 15; ++i) {
            for (int o = 0; o < 15; ++o) {
                Vector2i pos;
                Tile tile = new Tile();
                tile.pos = pos = new Vector2i(i, o);
                this.tiles.put(pos, tile);
            }
        }
    }

    @Override
    public boolean isFinished() {
        boolean finished = true;
        for (Tile i : this.tiles.values()) {
            if (i.type != 1 || this.isConnectedToEnd(i)) continue;
            finished = false;
            break;
        }
        return finished;
    }

    public boolean isConnectedToEnd(Tile tile) {
        if (tile.type == 1 || tile.type == 3) {
            Tile tile2 = this.getTile(tile.connectedTo);
            if (tile2 != null) {
                if (tile2.type == 2) {
                    return true;
                }
                return this.isConnectedToEnd(tile2);
            }
        } else {
            return true;
        }
        return false;
    }

    public Tile getTile(Vector2i pos) {
        return this.tiles.get(pos);
    }

    public Tile getTile(Vector2d pos) {
        return this.tiles.get(new Vector2i((int)Math.floor(pos.x / 10.0), (int)Math.floor(pos.y / 10.0)));
    }

    @Override
    public void render(DataBankScreen screen, GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY, int x, int y) {
        for (Tile i : this.tiles.values()) {
            if (i.type == 0) {
                pGuiGraphics.blit(TEXTURE, x + i.pos.x * 10, y + i.pos.y * 10, 22, 0, 10, 10);
                continue;
            }
            if (i.type == 1) {
                if (pMouseX >= x + i.pos.x * 10 && pMouseY >= y + i.pos.y * 10 && pMouseX <= x + i.pos.x * 10 + 9 && pMouseY <= y + i.pos.y * 10 + 9) {
                    pGuiGraphics.blit(TEXTURE, x + i.pos.x * 10, y + i.pos.y * 10, 11, 22 + i.essence * 11, 10, 10);
                    continue;
                }
                pGuiGraphics.blit(TEXTURE, x + i.pos.x * 10, y + i.pos.y * 10, 0, 22 + i.essence * 11, 10, 10);
                continue;
            }
            if (i.type == 2) {
                if (pMouseX >= x + i.pos.x * 10 && pMouseY >= y + i.pos.y * 10 && pMouseX <= x + i.pos.x * 10 + 9 && pMouseY <= y + i.pos.y * 10 + 9) {
                    pGuiGraphics.blit(TEXTURE, x + i.pos.x * 10, y + i.pos.y * 10, 33, 22 + i.essence * 11, 10, 10);
                    continue;
                }
                pGuiGraphics.blit(TEXTURE, x + i.pos.x * 10, y + i.pos.y * 10, 22, 22 + i.essence * 11, 10, 10);
                continue;
            }
            if (i.type != 3) continue;
            if (pMouseX >= x + i.pos.x * 10 && pMouseY >= y + i.pos.y * 10 && pMouseX <= x + i.pos.x * 10 + 9 && pMouseY <= y + i.pos.y * 10 + 9) {
                pGuiGraphics.blit(TEXTURE, x + i.pos.x * 10, y + i.pos.y * 10, 55, 22 + i.essence * 11, 10, 10);
                continue;
            }
            pGuiGraphics.blit(TEXTURE, x + i.pos.x * 10, y + i.pos.y * 10, 44, 22 + i.essence * 11, 10, 10);
        }
        for (Tile i : this.tiles.values()) {
            if (i.connectedTo == null) continue;
            int color = 0;
            if (i.essence == 0) {
                color = -1952017;
            }
            if (i.essence == 1) {
                color = -656448;
            }
            if (i.essence == 2) {
                color = -11013268;
            }
            if (i.essence == 3) {
                color = -1573639;
            }
            this.drawLine(new Vector2d((double)x + (double)i.pos.x * 10.0 + 6.0, (double)y + (double)i.pos.y * 10.0 + 6.0), new Vector2d((double)x + (double)i.connectedTo.x * 10.0 + 6.0, (double)y + (double)i.connectedTo.y * 10.0 + 6.0), color);
        }
        if (this.startLine != null && this.endLine != null) {
            Tile start = this.getTile(this.startLine);
            Tile end = this.getTile(this.endLine);
            boolean invalid = false;
            Line2D.Double line = new Line2D.Double(start.pos.x * 10 + 5, start.pos.y * 10 + 5, end.pos.x * 10 + 5, end.pos.y * 10 + 5);
            for (Tile i : this.tiles.values()) {
                Line2D.Double line2;
                if (i.connectedTo == null || i.connectedTo.equals((Object)start.pos) || i.pos.equals((Object)end.pos) || !line.intersectsLine(line2 = new Line2D.Double(i.pos.x * 10 + 5, i.pos.y * 10 + 5, i.connectedTo.x * 10 + 5, i.connectedTo.y * 10 + 5))) continue;
                invalid = true;
                break;
            }
            int color = this.lineColor;
            if (invalid) {
                color = 0xFF0000;
            }
            this.drawLine(new Vector2d(this.startLine.x + 1.0 + (double)x, this.startLine.y + 1.0 + (double)y), new Vector2d(this.endLine.x + 1.0 + (double)x, this.endLine.y + 1.0 + (double)y), color);
        }
    }

    @Override
    public void mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        if (pButton == 0 && this.endLine != null) {
            this.endLine.add(pDragX, pDragY);
        }
    }

    @Override
    public void mouseReleased(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0) {
            Tile end;
            Tile start;
            this.endLine = new Vector2d(pMouseX, pMouseY);
            if (this.startLine != null && (start = this.getTile(this.startLine)) != (end = this.getTile(this.endLine)) && start != null && end != null && start.essence == end.essence) {
                boolean invalid = false;
                Line2D.Double line = new Line2D.Double(start.pos.x * 10 + 5, start.pos.y * 10 + 5, end.pos.x * 10 + 5, end.pos.y * 10 + 5);
                for (Tile i : this.tiles.values()) {
                    Line2D.Double line2;
                    if (i.connectedTo == null || i.connectedTo.equals((Object)start.pos) || i.pos.equals((Object)end.pos) || !line.intersectsLine(line2 = new Line2D.Double(i.pos.x * 10 + 5, i.pos.y * 10 + 5, i.connectedTo.x * 10 + 5, i.connectedTo.y * 10 + 5))) continue;
                    invalid = true;
                    break;
                }
                if (!(invalid || start.connectedTo != null || end.type != 3 && end.type != 2)) {
                    start.connectedTo = end.pos;
                }
            }
            this.startLine = null;
            this.endLine = null;
        }
    }

    public void drawLine(Vector2d start, Vector2d end, int color) {
        GlStateManager._depthMask((boolean)false);
        GlStateManager._disableCull();
        RenderSystem.setShader(GameRenderer::getRendertypeLinesShader);
        Tesselator tess = RenderSystem.renderThreadTesselator();
        RenderSystem.lineWidth((float)(1.0f * (float)Minecraft.getInstance().getWindow().getGuiScale()));
        BufferBuilder buf = tess.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
        Vec2 vec = new Vec2((float)start.x - (float)end.x, (float)start.y - (float)end.y).normalized();
        buf.addVertex((float)start.x, (float)start.y, 0.0f).setColor(color).setNormal(vec.x, vec.y, 0.0f);
        buf.addVertex((float)end.x, (float)end.y, 0.0f).setColor(color).setNormal(vec.x, vec.y, 0.0f);
        BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        GlStateManager._enableCull();
        GlStateManager._depthMask((boolean)true);
        RenderSystem.lineWidth((float)1.0f);
    }

    @Override
    public void mouseClicked(double pMouseX, double pMouseY, int pButton) {
        super.mouseClicked(pMouseX, pMouseY, pButton);
        if (pButton == 0) {
            for (Tile i : this.tiles.values()) {
                if (!(pMouseX >= (double)(i.pos.x * 10)) || !(pMouseY >= (double)(i.pos.y * 10)) || !(pMouseX <= (double)(i.pos.x * 10 + 9)) || !(pMouseY <= (double)(i.pos.y * 10 + 9))) continue;
                if (i.type != 1 && i.type != 3) break;
                i.connectedTo = null;
                if (i.essence == 0) {
                    this.lineColor = -1952017;
                }
                if (i.essence == 1) {
                    this.lineColor = -656448;
                }
                if (i.essence == 2) {
                    this.lineColor = -11013268;
                }
                if (i.essence == 3) {
                    this.lineColor = -1573639;
                }
                this.startLine = new Vector2d((double)(i.pos.x * 10 + 5), (double)(i.pos.y * 10 + 5));
                this.endLine = new Vector2d(pMouseX, pMouseY);
                break;
            }
        }
    }

    @Override
    public String getLocalizationKey() {
        return "data_tablet.databank_minigame_wires";
    }

    public static class Tile {
        public Vector2i pos;
        public int type;
        public int essence;
        public Vector2i connectedTo;
    }

    public class Client {
        public Client(WireMinigame this$0) {
        }
    }
}

