/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.data.minigames;

import com.cmdpro.datanessence.api.databank.Minigame;
import com.cmdpro.datanessence.api.databank.MinigameCreator;
import com.cmdpro.datanessence.api.databank.MinigameSerializer;
import com.cmdpro.datanessence.data.minigames.LaserMinigame;
import com.cmdpro.datanessence.registry.MinigameRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import org.joml.Vector2i;

public class LaserMinigameCreator
extends MinigameCreator {
    public Map<Vector2i, LaserMinigame.Tile> tiles;

    public LaserMinigameCreator(Map<Vector2i, LaserMinigame.Tile> tiles) {
        this.tiles = tiles;
    }

    @Override
    public Minigame createMinigame() {
        return new LaserMinigame(this.tiles);
    }

    @Override
    public MinigameSerializer getSerializer() {
        return MinigameRegistry.LASER.get();
    }

    public static class LaserMinigameSerializer
    extends MinigameSerializer<LaserMinigameCreator> {
        public static final MapCodec<LaserMinigame.Tile> TILE_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("x").forGetter(obj -> obj.pos.x), (App)Codec.INT.fieldOf("y").forGetter(obj -> obj.pos.y), (App)Codec.STRING.optionalFieldOf("color", (Object)"red").xmap(i -> LaserMinigame.BeamColor.get(i).getIndex(), i -> LaserMinigame.BeamColor.getColor((int)i.intValue()).name).forGetter(obj -> obj.color), (App)Codec.STRING.fieldOf("type").xmap(i -> LaserMinigame.Tile.TileType.get(i).getIndex(), i -> LaserMinigame.Tile.TileType.getType((int)i.intValue()).name).forGetter(obj -> obj.type), (App)Codec.STRING.optionalFieldOf("rotation", (Object)"up").xmap(i -> LaserMinigame.Tile.TileRotation.get(i).getIndex(), i -> LaserMinigame.Tile.TileRotation.getRotation((int)i.intValue()).name).forGetter(obj -> obj.rotation)).apply((Applicative)instance, (x, y, color, type, rotation) -> new LaserMinigame.Tile(new Vector2i(x.intValue(), y.intValue()), (int)color, (int)type, (int)rotation)));
        public static final StreamCodec<RegistryFriendlyByteBuf, LaserMinigame.Tile> TILE_STREAM_CODEC = StreamCodec.of((pBuffer, pValue) -> {
            pBuffer.writeInt(pValue.pos.x);
            pBuffer.writeInt(pValue.pos.y);
            pBuffer.writeInt(pValue.color);
            pBuffer.writeInt(pValue.type);
            pBuffer.writeInt(pValue.rotation);
        }, pBuffer -> {
            int x = pBuffer.readInt();
            int y = pBuffer.readInt();
            Vector2i pos = new Vector2i(x, y);
            int color = pBuffer.readInt();
            int type = pBuffer.readInt();
            int rotation = pBuffer.readInt();
            return new LaserMinigame.Tile(pos, color, type, rotation);
        });
        public static final StreamCodec<RegistryFriendlyByteBuf, LaserMinigameCreator> STREAM_CODEC = StreamCodec.of((pBuffer, pValue) -> pBuffer.writeMap(pValue.tiles, (pBuffer2, pValue2) -> {
            pBuffer2.writeInt(pValue2.x);
            pBuffer2.writeInt(pValue2.y);
        }, (pBuffer2, pValue2) -> TILE_STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)pBuffer2), pValue2)), pBuffer -> {
            Map tiles = pBuffer.readMap(pBuffer2 -> {
                int x = pBuffer2.readInt();
                int y = pBuffer2.readInt();
                return new Vector2i(x, y);
            }, pBuffer2 -> (LaserMinigame.Tile)TILE_STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)pBuffer2)));
            return new LaserMinigameCreator(tiles);
        });
        public static final MapCodec<LaserMinigameCreator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TILE_CODEC.codec().listOf().fieldOf("tiles").xmap(a -> {
            HashMap<Vector2i, LaserMinigame.Tile> map = new HashMap<Vector2i, LaserMinigame.Tile>();
            for (LaserMinigame.Tile i : a) {
                map.put(i.pos, i);
            }
            return map;
        }, a -> a.values().stream().toList()).forGetter(minigame -> minigame.tiles)).apply((Applicative)instance, LaserMinigameCreator::new));

        @Override
        public MapCodec<LaserMinigameCreator> getCodec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, LaserMinigameCreator> getStreamCodec() {
            return STREAM_CODEC;
        }
    }
}

