/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.data.minigames;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.databank.Minigame;
import com.cmdpro.datanessence.screen.DataBankScreen;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.phys.Vec2;
import org.joml.Vector2d;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class LaserMinigame
extends Minigame {
    public static final ResourceLocation TEXTURE = DataNEssence.locate("textures/gui/data_bank_minigames.png");
    public HashMap<Vector2i, Tile> tiles;
    public List<Beam> beams = new ArrayList<Beam>();
    private int time;
    public boolean allEndsConnected;

    public LaserMinigame(Map<Vector2i, Tile> tiles) {
        this.setupTiles();
        this.tiles.putAll(tiles);
        this.rebuildBeams();
    }

    public void setupTiles() {
        this.tiles = new HashMap();
    }

    @Override
    public boolean isFinished() {
        return this.allEndsConnected;
    }

    public Tile getTile(Vector2i pos) {
        return this.tiles.get(pos);
    }

    public Tile getTile(Vector2d pos) {
        return this.tiles.get(new Vector2i((int)Math.floor(pos.x / 10.0), (int)Math.floor(pos.y / 10.0)));
    }

    @Override
    public void tick() {
        super.tick();
        ++this.time;
    }

    public void rebuildBeams() {
        this.beams.clear();
        for (Tile i : this.tiles.values()) {
            Beam build = i.onBeamBuild(this);
            if (build == null) continue;
            this.beams.add(build);
        }
        ArrayList<Beam> handledBeams = new ArrayList<Beam>();
        for (int j = 0; j < 10; ++j) {
            HashMap<Vector2i, List> beamEnds = new HashMap<Vector2i, List>();
            for (Beam beam : this.beams) {
                if (handledBeams.contains(beam)) continue;
                if (beam.end != null) {
                    List beamList = beamEnds.getOrDefault(beam.end, new ArrayList());
                    beamList.add(beam);
                    beamEnds.put(beam.end, beamList);
                }
                handledBeams.add(beam);
            }
            for (Map.Entry entry : beamEnds.entrySet()) {
                Tile tile = this.getTile((Vector2i)entry.getKey());
                tile.handleBeamEnds(this, (List)entry.getValue());
            }
            if (handledBeams.size() >= this.beams.size()) break;
        }
        boolean allGood = true;
        for (Tile i : this.tiles.values()) {
            if (i.getType() != Tile.TileType.GOAL) continue;
            boolean bl = false;
            for (Beam j : this.beams) {
                if (j.end == null || !j.end.equals((Object)i.pos)) continue;
                bl = true;
            }
            if (bl) continue;
            allGood = false;
            break;
        }
        this.allEndsConnected = allGood;
    }

    @Override
    public void render(DataBankScreen screen, GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY, int x, int y) {
        PoseStack stack;
        for (int i = 0; i < 15; ++i) {
            for (int o = 0; o < 15; ++o) {
                if (pMouseX >= x + i * 10 && pMouseY >= y + o * 10 && pMouseX <= x + i * 10 + 9 && pMouseY <= y + o * 10 + 9) {
                    pGuiGraphics.blit(TEXTURE, x + i * 10, y + o * 10, 0, 77, 10, 10);
                    continue;
                }
                pGuiGraphics.blit(TEXTURE, x + i * 10, y + o * 10, 0, 66, 10, 10);
            }
        }
        for (Beam beam : this.beams) {
            if (beam.beamParts.isEmpty()) continue;
            Beam.BeamSegment first = beam.beamParts.getFirst();
            Beam.BeamSegment last = beam.beamParts.getLast();
            ArrayList<Beam.BeamSegment> segmentPoints = new ArrayList<Beam.BeamSegment>();
            for (Beam.BeamSegment i : beam.beamParts) {
                boolean add = false;
                if (i == first || i == last) {
                    add = true;
                } else {
                    if (i.beamRenderOffsetChange.isPresent()) {
                        add = true;
                    }
                    if (i.colorChange.isPresent()) {
                        add = true;
                    }
                    if (i.wasDirectionChanged) {
                        add = true;
                    }
                }
                if (!add) continue;
                segmentPoints.add(i);
            }
            if (segmentPoints.getFirst() == null || !((Beam.BeamSegment)segmentPoints.getFirst()).colorChange.isPresent()) continue;
            Beam.BeamSegment lastSegment = null;
            BeamColor color = ((Beam.BeamSegment)segmentPoints.getFirst()).colorChange.get();
            for (Beam.BeamSegment i : segmentPoints) {
                Vec2 point = new Vec2((float)(x + i.pos.x * 10), (float)(y + i.pos.y * 10)).add(5.0f).add(i.beamRenderOffsetChange.orElse(Vec2.ZERO));
                BeamColor lastColor = color;
                if (i.colorChange.isPresent()) {
                    color = i.colorChange.get();
                }
                if (lastSegment != null) {
                    Vec2 from = new Vec2((float)(x + lastSegment.pos.x * 10), (float)(y + lastSegment.pos.y * 10)).add(5.0f).add(lastSegment.beamRenderOffsetChange.orElse(Vec2.ZERO));
                    this.drawLine(from.add(new Vec2(1.1f, 0.6f)), point.add(new Vec2(1.1f, 0.6f)), lastColor.color.getRGB());
                }
                lastSegment = i;
            }
        }
        for (Tile i : this.tiles.values()) {
            stack = pGuiGraphics.pose();
            stack.pushPose();
            stack.translate((float)(x + i.pos.x * 10 + 5), (float)(y + i.pos.y * 10 + 5), 0.0f);
            stack.mulPose(Axis.ZP.rotationDegrees(i.getRotationAngle()));
            boolean hovered = pMouseX >= x + i.pos.x * 10 && pMouseY >= y + i.pos.y * 10 && pMouseX <= x + i.pos.x * 10 + 9 && pMouseY <= y + i.pos.y * 10 + 9;
            i.render(screen, pGuiGraphics, pPartialTick, pMouseX, pMouseY, -5, -5, hovered);
            stack.popPose();
        }
        for (Tile i : this.tiles.values()) {
            stack = pGuiGraphics.pose();
            stack.pushPose();
            stack.translate((float)(x + i.pos.x * 10 + 5), (float)(y + i.pos.y * 10 + 5), 0.0f);
            stack.mulPose(Axis.ZP.rotationDegrees(i.getRotationAngle()));
            boolean hovered = pMouseX >= x + i.pos.x * 10 && pMouseY >= y + i.pos.y * 10 && pMouseX <= x + i.pos.x * 10 + 9 && pMouseY <= y + i.pos.y * 10 + 9;
            i.renderPost(screen, pGuiGraphics, pPartialTick, pMouseX, pMouseY, x + i.pos.x * 10, y + i.pos.y * 10, hovered);
            stack.popPose();
        }
    }

    public void drawLine(Vec2 start, Vec2 end, int color) {
        GlStateManager._depthMask((boolean)false);
        GlStateManager._disableCull();
        RenderSystem.setShader(GameRenderer::getRendertypeLinesShader);
        Tesselator tess = RenderSystem.renderThreadTesselator();
        RenderSystem.lineWidth((float)(2.0f * (float)Minecraft.getInstance().getWindow().getGuiScale()));
        BufferBuilder buf = tess.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
        Vec2 vec = new Vec2(start.x - end.x, start.y - end.y).normalized();
        buf.addVertex(start.x, start.y, 0.0f).setColor(color).setNormal(vec.x, vec.y, 0.0f);
        buf.addVertex(end.x, end.y, 0.0f).setColor(color).setNormal(vec.x, vec.y, 0.0f);
        BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        GlStateManager._enableCull();
        GlStateManager._depthMask((boolean)true);
        RenderSystem.lineWidth((float)1.0f);
    }

    @Override
    public void mouseClicked(double pMouseX, double pMouseY, int pButton) {
        super.mouseClicked(pMouseX, pMouseY, pButton);
        if (pButton == 0) {
            for (Tile i : this.tiles.values()) {
                if (!(pMouseX >= (double)(i.pos.x * 10)) || !(pMouseY >= (double)(i.pos.y * 10)) || !(pMouseX <= (double)(i.pos.x * 10 + 9)) || !(pMouseY <= (double)(i.pos.y * 10 + 9))) continue;
                if (!i.canPlayerRotate()) break;
                i.rotate(1);
                this.rebuildBeams();
                break;
            }
        }
    }

    public void addBeam(Beam beam) {
        if (beam != null) {
            this.beams.add(beam);
        }
    }

    @Override
    public String getLocalizationKey() {
        return "data_tablet.databank_minigame_laser";
    }

    public static class Tile {
        public Vector2i pos;
        public int type;
        public int color;
        public int rotation;

        public Tile(Vector2i pos, int type, int color) {
            this(pos, type, color, Tile.getFirstValidRotation(type).getIndex());
        }

        public Tile(Vector2i pos, int type, int color, int rotation) {
            this.pos = pos;
            this.type = type;
            this.color = color;
            this.rotation = rotation;
        }

        public Tile(Vector2i pos, TileType type, BeamColor color) {
            this(pos, type, color, Tile.getFirstValidRotation(type.getIndex()));
        }

        public Tile(Vector2i pos, TileType type, BeamColor color, TileRotation rotation) {
            this(pos, type.getIndex(), color.getIndex(), rotation.getIndex());
        }

        public BeamColor getColor() {
            return BeamColor.getColor(this.color);
        }

        public TileRotation getRotation() {
            return TileRotation.getRotation(this.rotation);
        }

        public TileType getType() {
            return TileType.getType(this.type);
        }

        public TileRotation[] getValidRotations() {
            return Tile.getValidRotations(this.type);
        }

        public static TileRotation[] getValidRotations(int type) {
            return TileType.getType((int)type).validRotations;
        }

        public static TileRotation getFirstValidRotation(int type) {
            Optional<TileRotation> rotation = Arrays.stream(Tile.getValidRotations(type)).findFirst();
            return rotation.orElse(TileRotation.UP);
        }

        public boolean canPlayerRotate() {
            return Tile.canPlayerRotate(this.getType());
        }

        public float getRotationAngle() {
            if (this.getType() == TileType.MIRROR) {
                return this.rotation == 3 ? -90.0f : 0.0f;
            }
            return this.getRotation().rotation;
        }

        public static boolean canPlayerRotate(TileType type) {
            return type.canPlayerRotate;
        }

        public void rotate(int amount) {
            TileRotation[] rotations = this.getValidRotations();
            int index = Arrays.stream(rotations).toList().indexOf((Object)this.getRotation());
            int rotation = (index + amount) % rotations.length;
            if (rotation < 0) {
                rotation = rotations.length + rotation;
            }
            this.rotation = rotations[rotation].getIndex();
        }

        public void render(DataBankScreen screen, GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY, int x, int y, boolean hovered) {
            boolean colorOverlay;
            int u = switch (this.getType().ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> 11;
                case 1 -> 22;
                case 2 -> 33;
                case 3 -> 44;
                case 4 -> 55;
                case 5 -> 66;
                case 6 -> 77;
            };
            int v = 66;
            switch (this.getType().ordinal()) {
                case 0: 
                case 1: 
                case 5: {
                    boolean bl = true;
                    break;
                }
                default: {
                    boolean bl = colorOverlay = false;
                }
            }
            if (hovered) {
                pGuiGraphics.blit(TEXTURE, x, y, u, v + 11, 10, 10);
            } else {
                pGuiGraphics.blit(TEXTURE, x, y, u, v, 10, 10);
            }
            if (colorOverlay) {
                float[] color = (float[])RenderSystem.getShaderColor().clone();
                Color tileColor = this.getColor().color;
                float red = (float)tileColor.getRed() / 255.0f;
                float green = (float)tileColor.getGreen() / 255.0f;
                float blue = (float)tileColor.getBlue() / 255.0f;
                float alpha = (float)tileColor.getAlpha() / 255.0f;
                RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
                pGuiGraphics.blit(TEXTURE, x, y, u, v + 22, 10, 10);
                RenderSystem.setShaderColor((float)color[0], (float)color[1], (float)color[2], (float)color[3]);
            }
        }

        public void renderPost(DataBankScreen screen, GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY, int x, int y, boolean hovered) {
        }

        public Beam.BeamModificationResult modifyBeam(LaserMinigame minigame, Beam beam, int depth) {
            Optional<BeamColor> beamColor = Optional.empty();
            Optional<TileRotation> beamRotation = Optional.empty();
            Optional<Vec2> beamRenderOffset = Optional.empty();
            boolean shouldStop = false;
            boolean reachedEnd = false;
            if (this.getType() == TileType.GOAL) {
                shouldStop = true;
                if (beam.color == this.color && beam.rotation == this.getRotation().getOpposite()) {
                    reachedEnd = true;
                }
            }
            if (this.getType() == TileType.MIRROR) {
                beamRotation = Optional.of(switch (beam.rotation.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> TileRotation.RIGHT;
                    case 3 -> TileRotation.DOWN;
                    case 2 -> TileRotation.LEFT;
                    case 1 -> TileRotation.UP;
                });
                if (this.getRotation() == TileRotation.LEFT) {
                    beamRotation = Optional.of(((TileRotation)((Object)beamRotation.get())).getOpposite());
                }
            }
            if (this.getType() == TileType.SPLITTER) {
                shouldStop = true;
                if (beam.rotation == this.getRotation().getOpposite()) {
                    Beam beam1 = Beam.buildBeam(minigame, new Vector2i((Vector2ic)this.pos), beam.getColor(), this.getRotation().getRight(), Vec2.ZERO, depth + 1);
                    Beam beam2 = Beam.buildBeam(minigame, new Vector2i((Vector2ic)this.pos), beam.getColor(), this.getRotation().getLeft(), Vec2.ZERO, depth + 1);
                    minigame.addBeam(beam1);
                    minigame.addBeam(beam2);
                }
            }
            if (this.getType() == TileType.PRISM) {
                if (beam.rotation == this.getRotation().getOpposite()) {
                    BeamColor originalBeamColor = beam.getColor();
                    if (originalBeamColor.color.getRed() > 0) {
                        Beam redBeam = Beam.buildBeam(minigame, new Vector2i((Vector2ic)this.pos), BeamColor.RED, this.getRotation().getOpposite().getLeft(), Vec2.ZERO, depth + 1);
                        minigame.addBeam(redBeam);
                    }
                    if (originalBeamColor.color.getGreen() > 0) {
                        Beam greenBeam = Beam.buildBeam(minigame, new Vector2i((Vector2ic)this.pos), BeamColor.GREEN, this.getRotation().getOpposite(), Vec2.ZERO, depth + 1);
                        minigame.addBeam(greenBeam);
                    }
                    if (originalBeamColor.color.getBlue() > 0) {
                        Beam blueBeam = Beam.buildBeam(minigame, new Vector2i((Vector2ic)this.pos), BeamColor.BLUE, this.getRotation().getOpposite().getRight(), Vec2.ZERO, depth + 1);
                        minigame.addBeam(blueBeam);
                    }
                } else {
                    reachedEnd = true;
                }
                shouldStop = true;
            }
            if (this.getType() == TileType.FILTER) {
                boolean red = false;
                boolean green = false;
                boolean blue = false;
                if (this.getColor().color.getRed() > 0) {
                    red = true;
                }
                if (this.getColor().color.getGreen() > 0) {
                    green = true;
                }
                if (this.getColor().color.getBlue() > 0) {
                    blue = true;
                }
                beamColor = Optional.of(BeamColor.get(red, green, blue));
            }
            if (this.getType() == TileType.WALL) {
                shouldStop = true;
            }
            return new Beam.BeamModificationResult(beamColor, beamRotation, beamRenderOffset, shouldStop, reachedEnd);
        }

        public void handleBeamEnds(LaserMinigame minigame, List<Beam> beams) {
            if (this.getType() == TileType.PRISM) {
                boolean red = false;
                boolean green = false;
                boolean blue = false;
                for (Beam i : beams) {
                    if (i.rotation == this.getRotation().getOpposite()) continue;
                    if (i.getColor().color.getRed() > 0) {
                        red = true;
                    }
                    if (i.getColor().color.getGreen() > 0) {
                        green = true;
                    }
                    if (i.getColor().color.getBlue() <= 0) continue;
                    blue = true;
                }
                BeamColor output = BeamColor.get(red, green, blue);
                if (output != null) {
                    minigame.addBeam(Beam.buildBeam(minigame, this.pos, output, this.getRotation(), Vec2.ZERO));
                }
            }
        }

        public Beam onBeamBuild(LaserMinigame minigame) {
            if (this.getType() == TileType.EMITTER) {
                return Beam.buildBeam(minigame, this.pos, this.getColor(), this.getRotation(), Vec2.ZERO);
            }
            return null;
        }

        public static enum TileRotation implements StringRepresentable
        {
            UP("up", new Vector2i(0, -1), 0.0f, 2, 3, 1),
            RIGHT("right", new Vector2i(1, 0), 90.0f, 3, 0, 2),
            DOWN("down", new Vector2i(0, 1), 180.0f, 0, 1, 3),
            LEFT("left", new Vector2i(-1, 0), -90.0f, 1, 2, 0);

            public final String name;
            public final Vector2i direction;
            public final float rotation;
            public final int opposite;
            public final int left;
            public final int right;

            private TileRotation(String name, Vector2i direction, float rotation, int opposite, int left, int right) {
                this.name = name;
                this.direction = direction;
                this.rotation = rotation;
                this.opposite = opposite;
                this.left = left;
                this.right = right;
            }

            public TileRotation getOpposite() {
                return TileRotation.getRotation(this.opposite);
            }

            public TileRotation getLeft() {
                return TileRotation.getRotation(this.left);
            }

            public TileRotation getRight() {
                return TileRotation.getRotation(this.right);
            }

            public int getIndex() {
                return this.ordinal();
            }

            public static TileRotation getRotation(int rotation) {
                TileRotation[] values = TileRotation.values();
                if (values.length > rotation) {
                    return values[rotation];
                }
                return null;
            }

            public static TileRotation[] noRotation() {
                return new TileRotation[]{UP};
            }

            public static TileRotation[] allRotation() {
                return TileRotation.values();
            }

            public static TileRotation[] leftRight() {
                return new TileRotation[]{LEFT, RIGHT};
            }

            public static TileRotation[] upDown() {
                return new TileRotation[]{UP, DOWN};
            }

            public static TileRotation get(String name) {
                for (TileRotation i : TileRotation.values()) {
                    if (!i.name.equals(name)) continue;
                    return i;
                }
                return null;
            }

            public String getSerializedName() {
                return this.name;
            }
        }

        public static enum TileType implements StringRepresentable
        {
            EMITTER("emitter", false, TileRotation.allRotation()),
            GOAL("goal", false, TileRotation.allRotation()),
            MIRROR("mirror", true, TileRotation.leftRight()),
            SPLITTER("splitter", true, TileRotation.allRotation()),
            PRISM("prism", true, TileRotation.allRotation()),
            FILTER("filter", false, TileRotation.noRotation()),
            WALL("wall", false, TileRotation.noRotation());

            public final boolean canPlayerRotate;
            public final TileRotation[] validRotations;
            public final String name;

            private TileType(String name, boolean canPlayerRotate, TileRotation[] validRotations) {
                this.canPlayerRotate = canPlayerRotate;
                this.validRotations = validRotations;
                this.name = name;
            }

            public int getIndex() {
                return this.ordinal();
            }

            public static TileType getType(int type) {
                TileType[] values = TileType.values();
                if (values.length > type) {
                    return values[type];
                }
                return null;
            }

            public static TileType get(String name) {
                for (TileType i : TileType.values()) {
                    if (!i.name.equals(name)) continue;
                    return i;
                }
                return null;
            }

            public String getSerializedName() {
                return this.name;
            }
        }
    }

    public static class Beam {
        public int color;
        public Tile.TileRotation rotation;
        public boolean stopped;
        public List<BeamSegment> beamParts = new ArrayList<BeamSegment>();
        public Vector2i end;

        public Beam(int color, Tile.TileRotation rotation) {
            this.color = color;
            this.rotation = rotation;
        }

        public BeamColor getColor() {
            return BeamColor.getColor(this.color);
        }

        public static Beam buildBeam(LaserMinigame minigame, Vector2i start, int color, Tile.TileRotation rotation, Vec2 firstOffset) {
            return Beam.buildBeam(minigame, start, BeamColor.getColor(color), rotation, firstOffset);
        }

        public static Beam buildBeam(LaserMinigame minigame, Vector2i start, BeamColor color, Tile.TileRotation rotation, Vec2 firstOffset) {
            return Beam.buildBeam(minigame, start, color, rotation, firstOffset, 0);
        }

        public static Beam buildBeam(LaserMinigame minigame, Vector2i start, BeamColor color, Tile.TileRotation rotation, Vec2 firstOffset, int depth) {
            if (depth > 5) {
                return null;
            }
            Beam beam = new Beam(color.getIndex(), rotation);
            Vector2i pos = new Vector2i((Vector2ic)start);
            beam.beamParts.clear();
            for (int i = 0; i < 100; ++i) {
                Vec2 offset;
                boolean colorChanged = false;
                boolean offsetChanged = false;
                boolean wasDirectionChanged = false;
                Tile tile = i > 0 ? minigame.getTile(pos) : null;
                Vec2 vec2 = offset = i > 0 ? Vec2.ZERO : firstOffset;
                if (i == 0) {
                    offsetChanged = true;
                    colorChanged = true;
                }
                if (tile != null) {
                    BeamModificationResult result = tile.modifyBeam(minigame, beam, depth);
                    if (result.rotation.isPresent()) {
                        beam.rotation = result.rotation.get();
                        wasDirectionChanged = true;
                    }
                    if (result.color.isPresent()) {
                        beam.color = result.color.get().getIndex();
                        colorChanged = true;
                    }
                    if (result.beamRenderOffset.isPresent()) {
                        offset = result.beamRenderOffset.get();
                        offsetChanged = true;
                    }
                    if (result.shouldStop) {
                        beam.stopped = true;
                    }
                    if (result.reachedEnd) {
                        beam.end = pos;
                    }
                } else if (pos.x < 0 || pos.y < 0 || pos.x >= 15 || pos.y >= 15) {
                    beam.stopped = true;
                }
                beam.beamParts.add(new BeamSegment(new Vector2i((Vector2ic)pos), colorChanged ? Optional.ofNullable(BeamColor.getColor(beam.color)) : Optional.empty(), offsetChanged ? Optional.of(offset) : Optional.empty(), wasDirectionChanged));
                if (beam.stopped) break;
                pos.add((Vector2ic)beam.rotation.direction);
            }
            return beam;
        }

        public record BeamModificationResult(Optional<BeamColor> color, Optional<Tile.TileRotation> rotation, Optional<Vec2> beamRenderOffset, boolean shouldStop, boolean reachedEnd) {
        }

        public record BeamSegment(Vector2i pos, Optional<BeamColor> colorChange, Optional<Vec2> beamRenderOffsetChange, boolean wasDirectionChanged) {
        }
    }

    public static enum BeamColor implements StringRepresentable
    {
        RED("red", Color.RED),
        GREEN("green", Color.GREEN),
        BLUE("blue", Color.BLUE),
        CYAN("cyan", Color.CYAN),
        MAGENTA("magenta", Color.MAGENTA),
        YELLOW("yellow", Color.YELLOW),
        WHITE("white", Color.WHITE);

        public final String name;
        public final Color color;

        private BeamColor(String name, Color color) {
            this.name = name;
            this.color = color;
        }

        public int getIndex() {
            return this.ordinal();
        }

        public static BeamColor getColor(int color) {
            BeamColor[] values = BeamColor.values();
            if (values.length > color) {
                return values[color];
            }
            return null;
        }

        public static BeamColor get(boolean red, boolean green, boolean blue) {
            for (BeamColor i : BeamColor.values()) {
                Color color = i.color;
                if (red && color.getRed() <= 0 || !red && color.getRed() > 0 || green && color.getGreen() <= 0 || !green && color.getGreen() > 0 || blue && color.getBlue() <= 0 || !blue && color.getBlue() > 0) continue;
                return i;
            }
            return null;
        }

        public static BeamColor get(String name) {
            for (BeamColor i : BeamColor.values()) {
                if (!i.name.equals(name)) continue;
                return i;
            }
            return null;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

