/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.data.minigames;

import com.cmdpro.databank.rendering.ColorUtil;
import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.databank.Minigame;
import com.cmdpro.datanessence.config.DataNEssenceClientConfig;
import com.cmdpro.datanessence.data.minigames.ColorMixingMinigameCreator;
import com.cmdpro.datanessence.registry.SoundRegistry;
import com.cmdpro.datanessence.screen.DataBankScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class ColorMixingMinigame
extends Minigame {
    public static final ResourceLocation TEXTURE = DataNEssence.locate("textures/gui/data_bank_minigames.png");
    public Color targetColor;
    public Color startColor;
    public List<ColorMixingMinigameCreator.ColorMixingMinigameSerializer.ColorManipulation> manipulations;
    public int maxManipulations;
    public int colorLevels;
    public int currentColorLevel;
    public boolean draggingSlider;

    public ColorMixingMinigame(List<ColorMixingMinigameCreator.ColorMixingMinigameSerializer.ColorManipulation> manipulations, Color startColor, int maxManipulations, int colorLevels) {
        this.targetColor = startColor;
        for (ColorMixingMinigameCreator.ColorMixingMinigameSerializer.ColorManipulation i : manipulations) {
            this.targetColor = ColorUtil.mixColorsSubtractive((Color)this.targetColor, (Color)i.color, (float)i.getIntensity());
        }
        this.startColor = startColor;
        this.maxManipulations = maxManipulations;
        this.colorLevels = colorLevels;
        this.manipulations = new ArrayList<ColorMixingMinigameCreator.ColorMixingMinigameSerializer.ColorManipulation>();
        this.currentColorLevel = colorLevels;
    }

    @Override
    public boolean isFinished() {
        if (DataNEssenceClientConfig.colorAssist) {
            return true;
        }
        Color currentColor = this.getCurrentColor();
        float[] targetHsv = Color.RGBtoHSB(this.targetColor.getRed(), this.targetColor.getGreen(), this.targetColor.getBlue(), null);
        float[] currentHsv = Color.RGBtoHSB(this.getCurrentColor().getRed(), currentColor.getGreen(), currentColor.getBlue(), null);
        int[] targetHsvInt = new int[3];
        int[] currentHsvInt = new int[3];
        for (int i = 0; i < 3; ++i) {
            targetHsvInt[i] = (int)(targetHsv[i] * 100.0f);
            currentHsvInt[i] = (int)(currentHsv[i] * 100.0f);
        }
        return currentHsvInt[0] == targetHsvInt[0] && currentHsvInt[1] == targetHsvInt[1] && currentHsvInt[2] == targetHsvInt[2];
    }

    @Override
    public String getLocalizationKey() {
        return "data_tablet.databank_minigame_color_mixing";
    }

    public Color getCurrentColor() {
        Color color = this.startColor;
        for (ColorMixingMinigameCreator.ColorMixingMinigameSerializer.ColorManipulation i : this.manipulations) {
            color = ColorUtil.mixColorsSubtractive((Color)color, (Color)i.color, (float)i.getIntensity());
        }
        return color;
    }

    @Override
    public void render(DataBankScreen screen, GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY, int x, int y) {
        Color currentColor = this.getCurrentColor();
        float[] color = (float[])RenderSystem.getShaderColor().clone();
        RenderSystem.setShaderColor((float)((float)currentColor.getRed() / 255.0f), (float)((float)currentColor.getGreen() / 255.0f), (float)((float)currentColor.getBlue() / 255.0f), (float)1.0f);
        RenderSystem.enableBlend();
        pGuiGraphics.blit(TEXTURE, x + 51, y + 51, 208, 0, 48, 48);
        RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        pGuiGraphics.blit(TEXTURE, x + 99 + 16, y + 47, 198, 48, 16, 16);
        RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        pGuiGraphics.blit(TEXTURE, x + 99 + 16, y + 47 + 20, 198, 48, 16, 16);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        pGuiGraphics.blit(TEXTURE, x + 99 + 16, y + 47 + 40, 198, 48, 16, 16);
        RenderSystem.setShaderColor((float)color[0], (float)color[1], (float)color[2], (float)color[3]);
        RenderSystem.disableBlend();
        pGuiGraphics.blit(TEXTURE, x + 59, y + 16, 192, 64, 32, 14);
        pGuiGraphics.fill(x + 69, y + 17, x + 69 + 12, y + 17 + 12, this.targetColor.getRGB());
        pGuiGraphics.drawCenteredString(Minecraft.getInstance().font, "Target", x + 75, y + 5, -1);
        float[] targetHsv = Color.RGBtoHSB(this.targetColor.getRed(), this.targetColor.getGreen(), this.targetColor.getBlue(), null);
        pGuiGraphics.drawCenteredString(Minecraft.getInstance().font, (int)(targetHsv[0] * 100.0f) + "% H | " + (int)(targetHsv[1] * 100.0f) + "% S | " + (int)(targetHsv[2] * 100.0f) + "% V", x + 75, y + 17 + 16, -1);
        float[] currentHsv = Color.RGBtoHSB(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue(), null);
        pGuiGraphics.drawCenteredString(Minecraft.getInstance().font, (int)(currentHsv[0] * 100.0f) + "% H | " + (int)(currentHsv[1] * 100.0f) + "% S | " + (int)(currentHsv[2] * 100.0f) + "% V", x + 75, y + 105, -1);
        int undoX = x + 27;
        int undoY = y + 55;
        int resetX = x + 27;
        int resetY = y + 79;
        int sliderX = x + 43 + (int)((float)this.currentColorLevel / (float)this.colorLevels * 64.0f - 2.5f);
        int sliderY = y + 123 - 8;
        if (!this.manipulations.isEmpty()) {
            if (pMouseX >= undoX && pMouseY >= undoY && pMouseX <= undoX + 16 && pMouseY <= undoY + 16) {
                pGuiGraphics.blit(TEXTURE, undoX, undoY, 240, 64, 16, 16);
            } else {
                pGuiGraphics.blit(TEXTURE, undoX, undoY, 224, 64, 16, 16);
            }
            RenderSystem.enableBlend();
            ColorMixingMinigameCreator.ColorMixingMinigameSerializer.ColorManipulation currentManipulation = this.manipulations.getLast();
            RenderSystem.setShaderColor((float)currentManipulation.color.getRed(), (float)currentManipulation.color.getGreen(), (float)currentManipulation.color.getBlue(), (float)1.0f);
            pGuiGraphics.blit(TEXTURE, undoX + 2, undoY + 2, 224, 80, 12, 12);
            RenderSystem.setShaderColor((float)color[0], (float)color[1], (float)color[2], (float)color[3]);
            RenderSystem.disableBlend();
            pGuiGraphics.blit(TEXTURE, undoX + 2, undoY + 10, 224, 92, 7, 2);
        }
        if (pMouseX >= resetX && pMouseY >= resetY && pMouseX <= resetX + 16 && pMouseY <= resetY + 16) {
            pGuiGraphics.blit(TEXTURE, resetX, resetY, 240, 48, 16, 16);
        } else {
            pGuiGraphics.blit(TEXTURE, resetX, resetY, 224, 48, 16, 16);
        }
        pGuiGraphics.hLine(x + 75 - 32, x + 75 + 32, y + 123, -14278235);
        if (pMouseX >= sliderX && pMouseY >= sliderY && pMouseX <= sliderX + 5 && pMouseY <= sliderY + 16) {
            pGuiGraphics.blit(TEXTURE, sliderX, sliderY, 219, 48, 5, 16);
        } else {
            pGuiGraphics.blit(TEXTURE, sliderX, sliderY, 214, 48, 5, 16);
        }
    }

    @Override
    public void mouseClicked(double pMouseX, double pMouseY, int pButton) {
        int sliderX = 43 + (int)((float)this.currentColorLevel / (float)this.colorLevels * 64.0f - 2.5f);
        int sliderY = 115;
        if (pMouseX >= (double)sliderX && pMouseY >= (double)sliderY && pMouseX <= (double)(sliderX + 5) && pMouseY <= (double)(sliderY + 16)) {
            this.draggingSlider = true;
        }
        int undoX = 27;
        int undoY = 55;
        int resetX = 27;
        int resetY = 79;
        if (pMouseX >= (double)undoX && pMouseY >= (double)undoY && pMouseX <= (double)(undoX + 16) && pMouseY <= (double)(undoY + 16)) {
            if (!this.manipulations.isEmpty()) {
                this.manipulations.removeLast();
            }
            Client.click();
        }
        if (pMouseX >= (double)resetX && pMouseY >= (double)resetY && pMouseX <= (double)(resetX + 16) && pMouseY <= (double)(resetY + 16)) {
            this.manipulations.clear();
            Client.click();
        }
        if (this.manipulations.size() + 1 <= this.maxManipulations) {
            int colorX = 115;
            int cyanY = 47;
            int magentaY = 67;
            int yellowY = 87;
            if (pMouseX >= (double)colorX && pMouseY >= (double)cyanY && pMouseX <= (double)(colorX + 16) && pMouseY <= (double)(cyanY + 16)) {
                Client.paint();
                this.manipulations.add(new ColorMixingMinigameCreator.ColorMixingMinigameSerializer.ColorManipulation(this.colorLevels, this.currentColorLevel, Color.CYAN));
            }
            if (pMouseX >= (double)colorX && pMouseY >= (double)magentaY && pMouseX <= (double)(colorX + 16) && pMouseY <= (double)(magentaY + 16)) {
                Client.paint();
                this.manipulations.add(new ColorMixingMinigameCreator.ColorMixingMinigameSerializer.ColorManipulation(this.colorLevels, this.currentColorLevel, Color.MAGENTA));
            }
            if (pMouseX >= (double)colorX && pMouseY >= (double)yellowY && pMouseX <= (double)(colorX + 16) && pMouseY <= (double)(yellowY + 16)) {
                Client.paint();
                this.manipulations.add(new ColorMixingMinigameCreator.ColorMixingMinigameSerializer.ColorManipulation(this.colorLevels, this.currentColorLevel, Color.YELLOW));
            }
        }
    }

    @Override
    public void mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.draggingSlider) {
            int sliderMinX = 43;
            int distFromMin = (int)pMouseX - sliderMinX;
            this.currentColorLevel = distFromMin < 0 ? 0 : (distFromMin > 64 ? this.colorLevels : Math.round((float)this.colorLevels * ((float)distFromMin / 64.0f)));
        }
    }

    @Override
    public void mouseReleased(double pMouseX, double pMouseY, int pButton) {
        this.draggingSlider = false;
    }

    public class Client {
        public Client(ColorMixingMinigame this$0) {
        }

        public static void click() {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value()), (float)1.0f, (float)1.0f));
        }

        public static void paint() {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundRegistry.COLOR_MIXING_MIX.value()), (float)1.0f, (float)1.0f));
        }
    }
}

