/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.data.hidden;

import com.cmdpro.databank.hidden.HiddenCondition;
import com.cmdpro.datanessence.data.datatablet.Entries;
import com.cmdpro.datanessence.data.datatablet.Entry;
import com.cmdpro.datanessence.registry.AttachmentTypeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class EntryCondition
extends HiddenCondition {
    public ResourceLocation entry;
    public int completionStage;

    public EntryCondition(ResourceLocation entry, int completionStage) {
        this.entry = entry;
        this.completionStage = completionStage;
    }

    public boolean isUnlocked(Player player) {
        if (player == null) {
            return true;
        }
        if (((ArrayList)player.getData(AttachmentTypeRegistry.UNLOCKED)).contains(this.entry)) {
            return true;
        }
        if (this.completionStage != -1) {
            Entry entry = Entries.entries.get(this.entry);
            return entry.getIncompleteStageServer(player) >= this.completionStage;
        }
        return false;
    }

    public HiddenCondition.Serializer getSerializer() {
        return EntryConditionSerializer.INSTANCE;
    }

    public static class EntryConditionSerializer
    extends HiddenCondition.Serializer<EntryCondition> {
        public static final EntryConditionSerializer INSTANCE = new EntryConditionSerializer();
        public static final MapCodec<EntryCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("entry").forGetter(condition -> condition.entry), (App)Codec.INT.optionalFieldOf("completion_stage", (Object)-1).forGetter(condition -> condition.completionStage)).apply((Applicative)instance, EntryCondition::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, EntryCondition> STREAM_CODEC = StreamCodec.of((buf, val) -> {
            buf.writeResourceLocation(val.entry);
            buf.writeInt(val.completionStage);
        }, buf -> {
            ResourceLocation entry = buf.readResourceLocation();
            int completionStage = buf.readInt();
            return new EntryCondition(entry, completionStage);
        });

        public MapCodec<EntryCondition> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, EntryCondition> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

